/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.MessageMgr;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.ResourceManagerException;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tranlog.ExternalXid;
import org.exolab.jms.tranlog.StateTransactionLogEntry;
import org.exolab.jms.tranlog.TransactionLog;
import org.exolab.jms.tranlog.TransactionLogException;
import org.exolab.jms.tranlog.TransactionState;
import org.exolab.jms.util.UUID;

public class ResourceManager
extends BasicService {
    private static final String RM_SERVICE_NAME = "XAResourceManager";
    private static final String RM_LOGFILE_PREFIX = "ojmsrm";
    public static final String RM_LOGFILE_EXTENSION = ".log";
    public static final int GC_DISABLED = 0;
    public static final int GC_SYNCHRONOUS = 1;
    public static final int GC_ASYNCHRONOUS = 2;
    private static ResourceManager _instance = null;
    private static final Object _initializer = new Object();
    private int _logFileSize = 1000000;
    private TreeSet _logs = new TreeSet(new TranLogFileComparator());
    private HashMap _tridToLogCache = new HashMap();
    private HashMap _logToTridCache = new HashMap();
    private final Object _cacheLock = new Object();
    private HashMap _activeTransactions = new HashMap();
    private String _logDirectory = ".";
    private long _lastLogNumber = 0L;
    private int _txExpiryTime = 120;
    private int _gcMode = 1;
    private String _rid = UUID.next();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$ResourceManager == null ? (class$org$exolab$jms$messagemgr$ResourceManager = ResourceManager.class$("org.exolab.jms.messagemgr.ResourceManager")) : class$org$exolab$jms$messagemgr$ResourceManager));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$ResourceManager;

    public static ResourceManager instance() throws ResourceManagerException {
        if (_instance == null) {
            Object object = _initializer;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new ResourceManager();
                }
            }
        }
        return _instance;
    }

    private ResourceManager() throws ResourceManagerException {
        this("./logs");
    }

    public ResourceManager(String dir) throws ResourceManagerException {
        super(RM_SERVICE_NAME);
        this._logDirectory = dir;
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            throw new ResourceManagerException(dir + " does not exist or is not a directory");
        }
        this.buildLogFileList();
        this.recover();
    }

    public void setLogDirectory(String dir) throws IllegalArgumentException {
        if (!new File(dir).isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        this._logDirectory = dir;
    }

    public String getLogDirectory() {
        return this._logDirectory;
    }

    public void setLogFileSize(int size) {
        this._logFileSize = size;
    }

    public int getLogFileSize() {
        return this._logFileSize;
    }

    public boolean setGCMode(int mode) {
        boolean result = false;
        if (mode == 0 || mode == 1 || mode == 2) {
            this._gcMode = mode;
            result = true;
        }
        return result;
    }

    public int getGCMode() {
        return this._gcMode;
    }

    public boolean gcDisabled() {
        return this._gcMode == 0;
    }

    public synchronized void logPublishedMessage(Xid xid, MessageImpl message) throws TransactionLogException, ResourceManagerException, JMSException {
        MessageMgr.instance().checkAndPrepareMessage(message);
        this.logTransactionData(new ExternalXid(xid), this._rid, this.createPublishedMessageWrapper(message));
    }

    public synchronized void logReceivedMessage(Xid xid, String id, MessageHandle handle) throws TransactionLogException, ResourceManagerException {
        this.logTransactionData(new ExternalXid(xid), this._rid, this.createReceivedMessageWrapper(id, handle));
    }

    public synchronized void logTransactionState(Xid xid, TransactionState state) throws TransactionLogException, ResourceManagerException {
        ExternalXid txid = new ExternalXid(xid);
        switch (state.getOrd()) {
            case 1: {
                TransactionLog log = this.getCurrentTransactionLog();
                this.addTridLogEntry(txid, log);
                log.logTransactionState(txid, this._txExpiryTime * 1000, this._rid, state);
                this._activeTransactions.put(txid, new LinkedList());
                break;
            }
            case 2: {
                LinkedList list = (LinkedList)this._activeTransactions.get(txid);
                if (list != null) {
                    list.add(state);
                    break;
                }
                throw new ResourceManagerException("Trasaction " + txid + " is not active.");
            }
            case 3: {
                TransactionLog log = this.getTransactionLog(txid);
                log.logTransactionState(txid, this._txExpiryTime * 1000, this._rid, state);
                this.removeTridLogEntry(txid, log);
                Object object = this._cacheLock;
                synchronized (object) {
                    if (this._logToTridCache.get(log) == null && !this.isCurrentTransactionLog(log)) {
                        log.close();
                        if (this._gcMode == 1) {
                            try {
                                log.destroy();
                            }
                            catch (TransactionLogException exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                this._activeTransactions.remove(txid);
                break;
            }
            default: {
                throw new ResourceManagerException("Cannot process tx state " + state);
            }
        }
    }

    synchronized void logTransactionData(ExternalXid txid, String rid, Object data) throws ResourceManagerException, TransactionLogException {
        this.getTransactionLog(txid).logTransactionData(txid, this._txExpiryTime * 1000, rid, data);
        LinkedList list = (LinkedList)this._activeTransactions.get(txid);
        if (list == null) {
            throw new ResourceManagerException("Trasaction " + txid + " is not active.");
        }
        list.add(data);
    }

    public void garbageCollect() {
        try {
            int gcfiles = 0;
            if (this._logs.size() == 0) {
                return;
            }
            TreeSet copy = null;
            TreeSet treeSet = this._logs;
            synchronized (treeSet) {
                copy = new TreeSet(this._logs);
            }
            copy.remove(this._logs.last());
            while (copy.size() > 0) {
                TransactionLog log = (TransactionLog)copy.first();
                copy.remove(log);
                if (!log.canGarbageCollect()) continue;
                log.destroy();
                TreeSet treeSet2 = this._logs;
                synchronized (treeSet2) {
                    this._logs.remove(log);
                }
                ++gcfiles;
            }
            _log.info((Object)("[RMGC] Collected " + gcfiles + " files."));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void commit(Xid id, boolean onePhase) throws XAException {
        Connection connection;
        ExternalXid xid;
        block24: {
            if (id == null) {
                throw new XAException(-4);
            }
            xid = new ExternalXid(id);
            if (!this.isTransactionActive(xid)) {
                throw new XAException(-6);
            }
            connection = null;
            connection = DatabaseService.getConnection();
            Object[] records = this.getTransactionRecords(xid, this._rid);
            int index = 0;
            while (index < records.length) {
                if (records[index] instanceof TransactionalObjectWrapper) {
                    TransactionalObjectWrapper wrapper = (TransactionalObjectWrapper)records[index];
                    if (wrapper.isPublishedMessage()) {
                        MessageMgr.instance().add(connection, (MessageImpl)wrapper.getObject());
                    } else if (wrapper.isReceivedMessage()) {
                        MessageHandle handle = ((ReceivedMessageWrapper)wrapper).getMessageHandle();
                        if (handle instanceof PersistentMessageHandle) {
                            MessageHandleFactory.destroyPersistentHandle(connection, (PersistentMessageHandle)handle);
                        } else {
                            handle.destroy();
                        }
                    }
                }
                ++index;
            }
            connection.commit();
            Object var10_12 = null;
            if (connection == null) break block24;
            try {
                connection.close();
            }
            catch (Exception nested) {
                // empty catch block
            }
        }
        try {
            this.logTransactionState(xid, TransactionState.CLOSED);
        }
        catch (Exception exception) {
            throw new XAException("Error processing commit : " + exception);
        }
        {
            catch (PersistenceException exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception nested) {
                        // empty catch block
                    }
                }
                throw new XAException("Failed in ResourceManager.commit : " + ((Throwable)((Object)exception)).toString());
            }
            catch (Exception exception) {
                throw new XAException("Failed in ResourceManager.commit : " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception nested) {
                    // empty catch block
                }
            }
            try {
                this.logTransactionState(xid, TransactionState.CLOSED);
            }
            catch (Exception exception) {
                throw new XAException("Error processing commit : " + exception);
            }
            throw throwable;
        }
    }

    public synchronized void end(Xid id, int flags) throws XAException {
        if (id == null) {
            throw new XAException(-4);
        }
        ExternalXid xid = new ExternalXid(id);
        if (flags != 0x2000000 || flags != 0x4000000 || flags != 0x20000000) {
            throw new XAException(-6);
        }
        switch (flags) {
            case 0x20000000: {
                if (!this.isTransactionActive(xid)) {
                    throw new XAException(-6);
                }
                this.rollback(xid);
                break;
            }
            case 0x2000000: {
                if (this.isTransactionActive(xid)) break;
                throw new XAException(-6);
            }
            case 0x4000000: {
                if (!this.isTransactionActive(xid)) break;
                throw new XAException(-6);
            }
        }
    }

    public synchronized void forget(Xid id) throws XAException {
        if (id == null) {
            throw new XAException(-4);
        }
        ExternalXid xid = new ExternalXid(id);
        if (!this.isTransactionActive(xid)) {
            throw new XAException(-6);
        }
        this.rollback(id);
    }

    public synchronized int getTransactionTimeout() throws XAException {
        return this._txExpiryTime;
    }

    public synchronized boolean isSameRM(XAResource xares) throws XAException {
        boolean result = false;
        if (xares == this || xares instanceof ResourceManager && ((ResourceManager)((Object)xares))._rid.equals(this._rid)) {
            result = true;
        }
        return result;
    }

    public synchronized int prepare(Xid id) throws XAException {
        if (id == null) {
            throw new XAException(-4);
        }
        ExternalXid xid = new ExternalXid(id);
        if (!this.isTransactionActive(xid)) {
            throw new XAException(-6);
        }
        try {
            this.logTransactionState(xid, TransactionState.PREPARED);
        }
        catch (Exception exception) {
            throw new XAException("Error processing prepare : " + exception);
        }
        return 0;
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        Xid[] result = new Xid[]{};
        if (flag == 0 || flag == 0x1000000 || flag == 0x800000) {
            LinkedList<Xid> xids = new LinkedList<Xid>();
            Iterator iter = this._activeTransactions.keySet().iterator();
            while (iter.hasNext()) {
                Object last;
                Xid xid = (Xid)iter.next();
                LinkedList list = (LinkedList)this._activeTransactions.get(xid);
                if (list.size() <= 1 || !((last = list.getLast()) instanceof StateTransactionLogEntry) || !((StateTransactionLogEntry)last).getState().isPrepared()) continue;
                xids.add(xid);
            }
            result = (Xid[])xids.toArray();
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public synchronized void rollback(Xid id) throws XAException {
        Connection connection;
        ExternalXid xid;
        block20: {
            if (id == null) {
                throw new XAException(-4);
            }
            xid = new ExternalXid(id);
            if (!this.isTransactionActive(xid)) {
                throw new XAException(-6);
            }
            connection = null;
            connection = DatabaseService.getConnection();
            Object[] records = this.getTransactionRecords(xid, this._rid);
            int index = 0;
            while (index < records.length) {
                TransactionalObjectWrapper wrapper;
                if (records[index] instanceof TransactionalObjectWrapper && !(wrapper = (TransactionalObjectWrapper)records[index]).isPublishedMessage() && wrapper.isReceivedMessage()) {
                    ReceivedMessageWrapper rmsg_wrapper = (ReceivedMessageWrapper)wrapper;
                    ConsumerEndpoint endpoint = ConsumerManager.instance().getConsumerEndpoint(rmsg_wrapper.getConsumerId());
                    if (endpoint != null) {
                        endpoint.returnMessage((MessageHandle)rmsg_wrapper.getObject());
                    }
                }
                ++index;
            }
            connection.commit();
            Object var10_12 = null;
            if (connection == null) break block20;
            try {
                connection.close();
            }
            catch (Exception nested) {
                // empty catch block
            }
        }
        try {
            this.logTransactionState(xid, TransactionState.CLOSED);
        }
        catch (Exception exception) {
            throw new XAException("Error processing rollback : " + exception);
        }
        {
            catch (PersistenceException exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception nested) {
                        // empty catch block
                    }
                }
                throw new XAException("Failed in ResourceManager.rollback : " + ((Throwable)((Object)exception)).toString());
            }
            catch (Exception exception) {
                throw new XAException("Failed in ResourceManager.rollback : " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception nested) {
                    // empty catch block
                }
            }
            try {
                this.logTransactionState(xid, TransactionState.CLOSED);
            }
            catch (Exception exception) {
                throw new XAException("Error processing rollback : " + exception);
            }
            throw throwable;
        }
    }

    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        this._txExpiryTime = seconds;
        return true;
    }

    public synchronized void start(Xid id, int flags) throws XAException {
        if (id == null) {
            throw new XAException(-4);
        }
        ExternalXid xid = new ExternalXid(id);
        if (flags != 0 || flags != 0x200000 || flags != 0x8000000) {
            throw new XAException(-6);
        }
        switch (flags) {
            case 0: {
                if (this.isTransactionActive(xid)) {
                    throw new XAException(-8);
                }
                try {
                    this.logTransactionState(xid, TransactionState.OPENED);
                    break;
                }
                catch (Exception exception) {
                    throw new XAException("Error processing start : " + exception);
                }
            }
            case 0x200000: 
            case 0x8000000: {
                if (this.isTransactionActive(xid)) break;
                throw new XAException(-6);
            }
        }
    }

    public void start() throws ServiceException {
        this.setState(ServiceState.RUNNING);
    }

    public void stop() throws ServiceException {
        this.setState(ServiceState.STOPPED);
    }

    public void run() {
    }

    public String getResourceManagerId() {
        return this._rid;
    }

    protected TransactionLog createNextTransactionLog() throws ResourceManagerException {
        TransactionLog newlog = null;
        TreeSet treeSet = this._logs;
        synchronized (treeSet) {
            try {
                long last = 1L;
                if (!this._logs.isEmpty()) {
                    last = this.getSequenceNumber(((TransactionLog)this._logs.last()).getName());
                }
                String name = this._logDirectory + System.getProperty("file.separator") + RM_LOGFILE_PREFIX + Long.toString(++last) + RM_LOGFILE_EXTENSION;
                newlog = new TransactionLog(name, true);
                this._logs.add(newlog);
            }
            catch (TransactionLogException exception) {
                throw new ResourceManagerException("Error in createNextTransactionLog " + exception);
            }
        }
        return newlog;
    }

    protected void buildLogFileList() {
        File dir = new File(this._logDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException(this._logDirectory + " is not a directory");
        }
        try {
            File[] list = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    boolean result = false;
                    if (name.startsWith(ResourceManager.RM_LOGFILE_PREFIX) && name.endsWith(ResourceManager.RM_LOGFILE_EXTENSION)) {
                        result = true;
                    }
                    return result;
                }
            });
            TreeSet treeSet = this._logs;
            synchronized (treeSet) {
                int index = 0;
                while (index < list.length) {
                    this._logs.add(new TransactionLog(list[index].getPath(), false));
                    ++index;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void recover() throws ResourceManagerException {
        try {
            if (!this._logs.isEmpty()) {
                Iterator iter = this._logs.iterator();
                while (iter.hasNext()) {
                    TransactionLog log = (TransactionLog)iter.next();
                    HashMap hashMap = log.recover();
                }
            }
        }
        catch (Exception exception) {
            throw new ResourceManagerException("Error in recover " + exception.toString());
        }
    }

    private TransactionLog getTransactionLog(ExternalXid txid) throws TransactionLogException, ResourceManagerException {
        TransactionLog log = (TransactionLog)this._tridToLogCache.get(txid);
        if (log == null) {
            log = this.getCurrentTransactionLog();
            this.addTridLogEntry(txid, log);
        }
        return log;
    }

    private TransactionLog getCurrentTransactionLog() throws TransactionLogException, ResourceManagerException {
        TransactionLog log = null;
        TreeSet treeSet = this._logs;
        synchronized (treeSet) {
            if (this._logs.size() > 0) {
                log = (TransactionLog)this._logs.last();
            }
            if (log == null || log.size() > (long)this._logFileSize) {
                log = this.createNextTransactionLog();
            }
        }
        return log;
    }

    private void addTridLogEntry(ExternalXid trid, TransactionLog log) {
        Object object = this._cacheLock;
        synchronized (object) {
            this._tridToLogCache.put(trid, log);
            Vector<ExternalXid> trids = (Vector<ExternalXid>)this._logToTridCache.get(log);
            if (trids == null) {
                trids = new Vector<ExternalXid>();
                this._logToTridCache.put(log, trids);
            }
            trids.addElement(trid);
        }
    }

    private boolean isCurrentTransactionLog(TransactionLog log) {
        boolean result = false;
        if (this._logs.size() > 0) {
            result = log.equals(this._logs.last());
        }
        return result;
    }

    private void removeTridLogEntry(ExternalXid trid, TransactionLog log) {
        Object object = this._cacheLock;
        synchronized (object) {
            this._tridToLogCache.remove(trid);
            Vector trids = (Vector)this._logToTridCache.get(log);
            if (trids != null) {
                trids.remove(trid);
                if (trids.size() == 0) {
                    this._logToTridCache.remove(log);
                }
            }
        }
    }

    protected Object[] getTransactionRecords(ExternalXid xid, String rid) {
        LinkedList list = (LinkedList)this._activeTransactions.get(xid);
        Object[] records = list != null ? list.toArray() : new Object[]{};
        return records;
    }

    protected long getSequenceNumber(String name) throws ResourceManagerException {
        int start = name.indexOf(RM_LOGFILE_PREFIX) + RM_LOGFILE_PREFIX.length();
        int end = name.indexOf(RM_LOGFILE_EXTENSION);
        try {
            return Long.parseLong(name.substring(start, end));
        }
        catch (NumberFormatException exception) {
            throw new ResourceManagerException("Invalid name assigned to resource manager file " + name);
        }
    }

    private synchronized boolean isTransactionActive(ExternalXid xid) {
        return this._activeTransactions.containsKey(xid);
    }

    private void dumpRecovered(HashMap records) {
        Iterator iter = records.keySet().iterator();
        while (iter.hasNext()) {
            ExternalXid txid = (ExternalXid)iter.next();
            LinkedList list = (LinkedList)records.get(txid);
            Iterator oiter = list.iterator();
            while (oiter.hasNext()) {
                Object object = oiter.next();
                if (object instanceof StateTransactionLogEntry) {
                    System.err.println("Recovered [" + txid + "] Class " + object.getClass().getName() + " [" + ((StateTransactionLogEntry)object).getState().toString() + "]");
                    continue;
                }
                System.err.println("Recovered [" + txid + "] Class " + object.getClass().getName());
            }
        }
    }

    private PublishedMessageWrapper createPublishedMessageWrapper(MessageImpl message) {
        return new PublishedMessageWrapper(message);
    }

    private ReceivedMessageWrapper createReceivedMessageWrapper(String id, MessageHandle handle) {
        return new ReceivedMessageWrapper(id, handle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReceivedMessageWrapper
    extends TransactionalObjectWrapper {
        private String _consumerId;

        public ReceivedMessageWrapper(String id, MessageHandle handle) {
            super(handle);
            this._consumerId = id;
        }

        public String getConsumerId() {
            return this._consumerId;
        }

        public MessageHandle getMessageHandle() {
            return (MessageHandle)super.getObject();
        }
    }

    private class PublishedMessageWrapper
    extends TransactionalObjectWrapper {
        public PublishedMessageWrapper(MessageImpl message) {
            super(message);
        }

        public MessageImpl getMessage() {
            return (MessageImpl)super.getObject();
        }
    }

    private abstract class TransactionalObjectWrapper {
        private Object _object;

        public TransactionalObjectWrapper(Object object) {
            this._object = object;
        }

        public boolean isPublishedMessage() {
            return this instanceof PublishedMessageWrapper;
        }

        public boolean isReceivedMessage() {
            return this instanceof ReceivedMessageWrapper;
        }

        public Object getObject() {
            return this._object;
        }
    }

    private class TranLogFileComparator
    implements Comparator {
        private TranLogFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            int result;
            block3: {
                result = -1;
                try {
                    if (o1 instanceof TransactionLog && o2 instanceof TransactionLog) {
                        long seq2;
                        long seq1 = ResourceManager.this.getSequenceNumber(((TransactionLog)o1).getName());
                        result = seq1 > (seq2 = ResourceManager.this.getSequenceNumber(((TransactionLog)o2).getName())) ? 1 : (seq1 < seq2 ? -1 : 0);
                        break block3;
                    }
                    throw new ClassCastException("o1 = " + o1.getClass().getName() + " and o2 = " + o2.getClass().getName());
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error in ResourceManager.compare " + exception.toString());
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof TranLogFileComparator;
        }
    }
}

