/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.FailedToInitializeException;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.QueueBrowserEndpoint;
import org.exolab.jms.messagemgr.QueueConsumerEndpoint;
import org.exolab.jms.messagemgr.QueueListener;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.selector.Selector;
import org.exolab.jms.server.JmsServerConnectionManager;

public class QueueDestinationCache
extends DestinationCache {
    protected List _queueListeners = Collections.synchronizedList(new LinkedList());
    private JmsQueue _queue = null;
    private int _lastConsumerIndex = 0;
    private long _publishCount;
    private long _consumeCount;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$QueueDestinationCache == null ? (class$org$exolab$jms$messagemgr$QueueDestinationCache = QueueDestinationCache.class$("org.exolab.jms.messagemgr.QueueDestinationCache")) : class$org$exolab$jms$messagemgr$QueueDestinationCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$QueueDestinationCache;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QueueDestinationCache(JmsQueue destination) throws FailedToInitializeException {
        this._queue = destination;
        this.init();
        if (!DestinationManager.instance().isAdministeredDestination(destination.getName())) return;
        Connection connection = null;
        Object tm = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                this.init(destination, connection);
                connection.commit();
            }
            catch (PersistenceException exception) {
                if (connection == null) throw new FailedToInitializeException("QueueDestinationCache init failed " + (Object)((Object)exception));
                try {
                    connection.rollback();
                    throw new FailedToInitializeException("QueueDestinationCache init failed " + (Object)((Object)exception));
                }
                catch (Exception nested) {
                    // empty catch block
                }
                throw new FailedToInitializeException("QueueDestinationCache init failed " + (Object)((Object)exception));
            }
            catch (Exception exception) {
                throw new FailedToInitializeException("QueueDestinationCache init failed " + exception);
            }
            Object var7_4 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception nested) {}
        connection.close();
        return;
    }

    QueueDestinationCache(Connection connection, JmsQueue destination) throws FailedToInitializeException {
        this._queue = destination;
        this.init(connection);
        if (DestinationManager.instance().isAdministeredDestination(destination.getName())) {
            try {
                this.init(destination, connection);
            }
            catch (Exception exception) {
                throw new FailedToInitializeException("QueueDestinationCache init failed " + exception);
            }
        }
    }

    void init(JmsQueue destination, Connection connection) throws PersistenceException {
        DatabaseService.getAdapter().removeExpiredMessageHandles(connection, destination.getName());
        Vector handles = DatabaseService.getAdapter().getMessageHandles(connection, destination, destination.getName());
        if (handles != null) {
            Enumeration iter = handles.elements();
            while (iter.hasMoreElements()) {
                this.addMessage((MessageHandle)iter.nextElement());
            }
        }
    }

    public JmsDestination getDestination() {
        return this._queue;
    }

    public void addQueueListener(QueueListener listener) {
        if (!this._queueListeners.contains(listener)) {
            this._queueListeners.add(listener);
        }
    }

    public void removeQueueListener(QueueListener listener) {
        if (this._queueListeners.contains(listener)) {
            this._queueListeners.remove(listener);
        }
    }

    public boolean messageAdded(JmsDestination destination, MessageImpl message) {
        boolean processed = false;
        if (destination != null && message != null) {
            if (destination.equals(this._queue)) {
                try {
                    MessageHandle handle = MessageHandleFactory.createHandle(this, message);
                    this.addMessage(handle, message);
                    ++this._publishCount;
                    QueueConsumerEndpoint endpoint = this.getEndpointForMessage(message);
                    if (endpoint != null) {
                        endpoint.messageAdded(message);
                    }
                    this.notifyQueueListeners(message);
                    this.checkMessageExpiry(message);
                    processed = true;
                }
                catch (JMSException exception) {
                    _log.error((Object)"Failed to add message", (Throwable)exception);
                }
            } else {
                _log.error((Object)("Dropping message " + message.getMessageId() + " for destination " + destination.getName()));
            }
        }
        return processed;
    }

    public void messageRemoved(JmsDestination destination, MessageImpl message) {
        if (destination != null && message != null) {
            try {
                MessageHandle handle = MessageHandleFactory.getHandle(this, message);
                if (destination.equals(this._queue)) {
                    this.removeMessage(handle);
                    this.notifyOnRemoveMessage(message);
                    handle.destroy();
                }
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to remove message", (Throwable)exception);
            }
        }
    }

    public boolean persistentMessageAdded(Connection connection, JmsDestination destination, MessageImpl message) throws PersistenceException {
        boolean processed = false;
        if (destination != null && message != null && destination.equals(this._queue)) {
            try {
                MessageHandle handle = MessageHandleFactory.getHandle(this, message);
                this.addMessage(handle, message);
                ++this._publishCount;
                QueueConsumerEndpoint endpoint = this.getEndpointForMessage(message);
                if (endpoint != null) {
                    endpoint.persistentMessageAdded(connection, message);
                }
                this.notifyQueueListeners(message);
                this.checkMessageExpiry(message);
                processed = true;
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to add persistent message", (Throwable)exception);
            }
        }
        return processed;
    }

    public synchronized void persistentMessageRemoved(Connection connection, JmsDestination destination, MessageImpl message) throws PersistenceException {
        if (destination != null && message != null) {
            try {
                PersistentMessageHandle handle = (PersistentMessageHandle)MessageHandleFactory.getHandle(this, message);
                if (destination.equals(this._queue)) {
                    this.removeMessage(handle);
                    this.notifyOnRemovePersistentMessage(connection, message);
                    MessageHandleFactory.destroyPersistentHandle(connection, handle);
                }
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to remove persistent message", (Throwable)exception);
            }
        }
    }

    private synchronized QueueConsumerEndpoint getEndpointForMessage(MessageImpl message) {
        QueueConsumerEndpoint selectedEndpoint = null;
        if (this._consumers.size() > 0) {
            if (this._lastConsumerIndex + 1 > this._consumers.size()) {
                this._lastConsumerIndex = 0;
            }
            int index = this._lastConsumerIndex;
            do {
                QueueConsumerEndpoint endpoint = (QueueConsumerEndpoint)this._consumers.get(index);
                Selector selector = endpoint.getSelector();
                if ((endpoint.hasMessageListener() || endpoint.isWaitingForMessage()) && (selector == null || selector.selects(message))) {
                    this._lastConsumerIndex = ++index;
                    selectedEndpoint = endpoint;
                    break;
                }
                if (++index < this._consumers.size()) continue;
                index = 0;
            } while (index != this._lastConsumerIndex);
        }
        return selectedEndpoint;
    }

    public synchronized MessageHandle getMessage(QueueConsumerEndpoint endpoint) {
        MessageHandle handle = null;
        if (endpoint != null && this.getMessageCount() > 0) {
            Selector selector = endpoint.getSelector();
            if (selector == null) {
                handle = this.removeFirstMessage();
                ++this._consumeCount;
            } else {
                Object[] handles = this.toMessageArray();
                int i = 0;
                while (i < handles.length) {
                    MessageHandle hdl = (MessageHandle)handles[i];
                    MessageImpl message = hdl.getMessage();
                    if (message != null && selector.selects(message)) {
                        handle = hdl;
                        this.removeMessage(hdl);
                        ++this._consumeCount;
                        break;
                    }
                    ++i;
                }
            }
        }
        return handle;
    }

    public void playbackMessages(QueueListener listener) {
        Object[] messages = this.toMessageArray();
        if (listener != null && messages.length > 0) {
            try {
                int index = 0;
                while (index < messages.length) {
                    listener.onMessage(((MessageHandle)messages[index]).getMessage());
                    ++index;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public synchronized void returnMessage(MessageHandle handle) {
        this.addMessage(handle);
        if (this._consumers.size() > 0) {
            int index;
            if (this._lastConsumerIndex + 1 > this._consumers.size()) {
                this._lastConsumerIndex = 0;
            }
            int n = index = this._lastConsumerIndex >= this._consumers.size() ? 0 : this._lastConsumerIndex;
            do {
                QueueConsumerEndpoint endpoint;
                if ((endpoint = (QueueConsumerEndpoint)this._consumers.get(index)).hasMessageListener()) {
                    endpoint.schedule();
                    this._lastConsumerIndex = ++index;
                    break;
                }
                if (++index < this._consumers.size()) continue;
                index = 0;
            } while (index != this._lastConsumerIndex);
        }
    }

    void notifyQueueListeners(MessageImpl message) {
        if (!this._queueListeners.isEmpty()) {
            QueueListener[] listeners = this._queueListeners.toArray(new QueueListener[0]);
            int size = listeners.length;
            int index = 0;
            while (index < size) {
                QueueListener listener = listeners[index];
                if (listener instanceof QueueBrowserEndpoint) {
                    QueueBrowserEndpoint browser = (QueueBrowserEndpoint)listener;
                    Selector selector = browser.getSelector();
                    if (selector == null || selector.selects(message)) {
                        browser.onMessage(message);
                    }
                } else {
                    listener.onMessage(message);
                }
                ++index;
            }
        }
    }

    boolean notifyOnAddMessage(MessageImpl message) {
        return true;
    }

    void notifyOnRemoveMessage(MessageImpl message) {
    }

    boolean hasActiveConsumers() {
        boolean active = true;
        if (this._queueListeners.isEmpty() && this._consumers.isEmpty()) {
            active = false;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("hasActiveConsumers()[queue=" + this._queue + "]=" + active));
        }
        return active;
    }

    public boolean canDestroy() {
        boolean destroy = false;
        if (!this.hasActiveConsumers()) {
            JmsDestination queue = this.getDestination();
            if (queue.getPersistent() && this.getMessageCount() == 0) {
                destroy = true;
            } else if (queue.isTemporaryDestination()) {
                String connectionId = ((JmsTemporaryDestination)((Object)queue)).getConnectionId();
                JmsServerConnectionManager manager = JmsServerConnectionManager.instance();
                if (manager.getConnection(connectionId) == null) {
                    destroy = true;
                }
            }
        }
        return destroy;
    }

    synchronized void destroy() {
        super.destroy();
        this._queueListeners.clear();
    }

    public String toString() {
        return this._queue.toString();
    }

    public int hashCode() {
        return this._queue.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

