/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.InternalMessageListener;
import org.exolab.jms.messagemgr.QueueDestinationCache;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.ClientDisconnectionException;
import org.exolab.jms.server.JmsServerSession;

public class QueueConsumerEndpoint
extends ConsumerEndpoint {
    private QueueDestinationCache _cache = null;
    private JmsQueue _queue = null;
    private final int MAX_MESSAGES = 200;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$QueueConsumerEndpoint == null ? (class$org$exolab$jms$messagemgr$QueueConsumerEndpoint = QueueConsumerEndpoint.class$("org.exolab.jms.messagemgr.QueueConsumerEndpoint")) : class$org$exolab$jms$messagemgr$QueueConsumerEndpoint));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$QueueConsumerEndpoint;

    QueueConsumerEndpoint(JmsServerSession session, long clientId, JmsQueue queue, String selector, Scheduler scheduler) throws InvalidSelectorException {
        super(session, clientId, selector, scheduler);
        if (queue != null) {
            this._queue = queue;
            this._cache = (QueueDestinationCache)DestinationManager.instance().getDestinationCache(queue);
            if (this._cache == null) {
                this._cache = (QueueDestinationCache)DestinationManager.instance().createDestinationCache(queue);
            }
            this._cache.registerConsumer(this);
        }
    }

    public int getMessageCount() {
        return this._cache.getMessageCount();
    }

    public boolean deliverMessages() {
        boolean reschedule = true;
        int index = 0;
        while (index < 200) {
            if (this.stopDelivery()) {
                reschedule = false;
                break;
            }
            MessageHandle handle = null;
            try {
                handle = this._cache.getMessage(this);
                if (handle == null) {
                    reschedule = false;
                    break;
                }
                handle.setClientId(this.getClientId());
                this._listener.onMessage(handle, true);
            }
            catch (ClientDisconnectionException exception) {
                if (handle != null) {
                    this._cache.returnMessage(handle);
                }
                this._listener = null;
                _log.error((Object)exception, (Throwable)exception);
            }
            catch (JMSException exception) {
                if (exception.getErrorCode().equals("FailedToResolveHandle")) {
                    _log.error((Object)("Dropping handle " + handle + " since we cannot resolve it."));
                } else {
                    _log.error((Object)exception, (Throwable)exception);
                    if (handle != null) {
                        this._cache.returnMessage(handle);
                    }
                }
            }
            catch (Exception exception) {
                if (handle != null) {
                    this._cache.returnMessage(handle);
                }
                _log.error((Object)exception);
            }
            ++index;
        }
        return reschedule;
    }

    public void setMessageListener(InternalMessageListener listener) {
        if (listener == null) {
            this._cache.unregisterConsumer(this);
        } else {
            this._cache.registerConsumer(this);
        }
        super.setMessageListener(listener);
    }

    public MessageHandle receiveMessage(long wait) {
        MessageHandle handle = this.getMessageFromCache();
        if (handle == null && wait >= 0L) {
            this.setWaitingForMessage();
            handle = this.getMessageFromCache();
            if (handle != null) {
                this.clearWaitingForMessage();
            }
        }
        return handle;
    }

    public boolean hasMessageListener() {
        return this._listener != null;
    }

    public void unregister() {
        this._cache.unregisterConsumer(this);
    }

    public JmsDestination getDestination() {
        return this._queue;
    }

    public boolean messageAdded(MessageImpl message) {
        if (this._listener != null) {
            this.schedule();
        } else {
            this.notifyMessageAvailable();
        }
        return true;
    }

    public boolean persistentMessageAdded(Connection connection, MessageImpl message) throws PersistenceException {
        if (this._listener != null) {
            this.schedule();
        } else {
            this.notifyMessageAvailable();
        }
        return true;
    }

    public synchronized boolean messageRemoved(MessageImpl message) {
        return false;
    }

    protected void doClose() {
        this._cache.unregisterConsumer(this);
    }

    private MessageHandle getMessageFromCache() {
        MessageHandle handle = this._cache.getMessage(this);
        if (handle != null) {
            handle.setClientId(this.getClientId());
        }
        return handle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

