/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.util.Vector;
import javax.jms.InvalidSelectorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.InternalMessageListener;
import org.exolab.jms.messagemgr.QueueDestinationCache;
import org.exolab.jms.messagemgr.QueueListener;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.JmsServerSession;

public class QueueBrowserEndpoint
extends ConsumerEndpoint
implements QueueListener {
    private QueueDestinationCache _cache = null;
    private JmsQueue _queue = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$QueueBrowserEndpoint == null ? (class$org$exolab$jms$messagemgr$QueueBrowserEndpoint = QueueBrowserEndpoint.class$("org.exolab.jms.messagemgr.QueueBrowserEndpoint")) : class$org$exolab$jms$messagemgr$QueueBrowserEndpoint));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$QueueBrowserEndpoint;

    QueueBrowserEndpoint(JmsServerSession session, long clientId, JmsQueue destination, String selector, Scheduler scheduler) throws InvalidSelectorException {
        super(session, clientId, selector, scheduler);
        this._cache = (QueueDestinationCache)DestinationManager.instance().getDestinationCache(destination);
        if (this._cache == null) {
            this._cache = (QueueDestinationCache)DestinationManager.instance().createDestinationCache(destination);
        }
        this._queue = destination;
        this._cache.addQueueListener(this);
        this._cache.playbackMessages(this);
    }

    public boolean deliverMessages() {
        _log.error((Object)"QueueBrowserEndpoint.deliverMessages() should never be called", (Throwable)new Exception());
        return false;
    }

    public synchronized MessageHandle receiveMessage(long wait) {
        throw new UnsupportedOperationException("Cannot call receiveMessage for QueueBrowser");
    }

    public synchronized Vector receiveMessages(int count) {
        Vector<MessageHandle> messages = new Vector<MessageHandle>();
        int index = 0;
        while (index < count) {
            if (this.isStopped() || this.getMessageCount() == 0) break;
            try {
                MessageHandle handle = this.removeFirstMessage();
                MessageImpl m = handle.getMessage();
                if (m == null || this._selector != null && !this._selector.selects(m)) continue;
                handle.setClientId(this.getClientId());
                messages.addElement(handle);
                ++index;
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        return messages;
    }

    public JmsDestination getDestination() {
        return this._queue;
    }

    public void unregister() {
        this._cache.unregisterConsumer(this);
    }

    public void returnMessage(MessageHandle handle) {
    }

    public void onMessage(MessageImpl message) {
        this.messageAdded(message);
    }

    public void setMessageListener(InternalMessageListener listener) {
        _log.error((Object)"QueueBrowserEndpoint.setMessageListener should never be called");
        Thread.currentThread();
        Thread.dumpStack();
    }

    protected void doClose() {
        this._cache.removeQueueListener(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

