/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import javax.jms.JMSException;
import org.exolab.core.foundation.PersistentObject;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageMgr;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

public class PersistentMessageHandle
extends PersistentObject
implements MessageHandle,
Cloneable {
    static final long serialVersionUID = 1L;
    private MessageId _id = null;
    private int _priority;
    private boolean _delivered;
    private transient long _clientId = -1L;
    private long _acceptedTime;
    private long _sequenceNumber;
    private long _expiryTime;
    private String _consumerName;
    private JmsDestination _destination;
    private transient int _hashCode = -1;

    public PersistentMessageHandle() {
    }

    public PersistentMessageHandle(MessageImpl message) throws JMSException {
        if (message == null || message.getJMSDeliveryMode() != 2) {
            throw new JMSException("Cannot create persistent handle from non-persistent message");
        }
        this._id = message.getMessageId();
        this._priority = message.getJMSPriority();
        this._delivered = message.getJMSRedelivered();
        this._destination = (JmsDestination)message.getJMSDestination();
        this._acceptedTime = message.getAcceptedTime();
        this._expiryTime = message.getJMSExpiration();
        this._sequenceNumber = message.getSequenceNumber();
        this._clientId = message.getClientId();
    }

    public void setMessageId(MessageId id) {
        this._id = id;
    }

    public MessageId getMessageId() {
        return this._id;
    }

    public MessageImpl getMessage() {
        return MessageMgr.instance().getMessage(this);
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setDelivered(boolean value) {
        this._delivered = value;
    }

    public boolean getDelivered() {
        return this._delivered;
    }

    public void setAcceptedTime(long time) {
        this._acceptedTime = time;
    }

    public long getAcceptedTime() {
        return this._acceptedTime;
    }

    public void setSequenceNumber(long seq) {
        this._sequenceNumber = seq;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setExpiryTime(long time) {
        this._expiryTime = time;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }

    public boolean hasExpired() {
        return this._expiryTime != 0L && this._expiryTime <= System.currentTimeMillis();
    }

    public void setConsumerName(String name) {
        this._consumerName = name;
    }

    public String getConsumerName() {
        return this._consumerName;
    }

    public boolean isPersistent() {
        return true;
    }

    public void setDestination(JmsDestination destination) {
        this._destination = destination;
    }

    public JmsDestination getDestination() {
        return this._destination;
    }

    public void setClientId(long clientId) {
        this._clientId = clientId;
    }

    public long getClientId() {
        return this._clientId;
    }

    public void clear() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        MessageMgr.instance().handleDestroyed(this);
        Connection connection = null;
        Object tm = null;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().removeMessageHandle(connection, this);
        connection.commit();
        Object var6_3 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception nested) {}
        return;
        {
            catch (PersistenceException exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception nested) {
                    }
                }
                Object var6_4 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception nested) {}
                return;
            }
            catch (Exception exception) {
                Object var6_5 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception nested) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PersistentMessageHandle handle = (PersistentMessageHandle)super.clone();
        handle._id = new MessageId(this._id.getId());
        handle._priority = this._priority;
        handle._delivered = this._delivered;
        handle._acceptedTime = this._acceptedTime;
        handle._expiryTime = this._expiryTime;
        handle._consumerName = this._consumerName;
        handle._sequenceNumber = this._sequenceNumber;
        handle._destination = this._destination instanceof JmsQueue ? new JmsQueue(this._destination.getName()) : new JmsTopic(this._destination.getName());
        handle._destination.setPersistent(true);
        return handle;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && object instanceof PersistentMessageHandle) {
            PersistentMessageHandle mhdl = (PersistentMessageHandle)object;
            if (mhdl._id.equals(this._id)) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        return "Handle : " + this._id.getId() + "@" + this._consumerName + ":" + this._sequenceNumber + ":" + this._acceptedTime + ":" + this._priority;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            this._hashCode = (this._id + this._consumerName).hashCode();
        }
        return this._hashCode;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDelivered() {
        if (this._delivered) return;
        Connection connection = null;
        Object tm = null;
        connection = DatabaseService.getConnection();
        DatabaseService.getAdapter().updateMessageHandle(connection, this);
        this._delivered = true;
        connection.commit();
        Object var6_3 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception nested) {}
        return;
        {
            catch (PersistenceException exception) {
                System.err.println("Failed in setDelivereds b/c " + ((Throwable)((Object)exception)).toString());
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception nested) {
                    }
                }
                Object var6_4 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception nested) {}
                return;
            }
            catch (Exception exception) {
                Object var6_5 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception nested) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception nested) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeObject(this._id);
        stream.writeInt(this._priority);
        stream.writeBoolean(this._delivered);
        stream.writeLong(this._acceptedTime);
        stream.writeLong(this._sequenceNumber);
        stream.writeLong(this._expiryTime);
        stream.writeObject(this._consumerName);
        stream.writeObject(this._destination);
        super.writeExternal(stream);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("PersistentMessageHandle with version " + version + " is not supported.");
        }
        this._id = (MessageId)stream.readObject();
        this._priority = stream.readInt();
        this._delivered = stream.readBoolean();
        this._acceptedTime = stream.readLong();
        this._sequenceNumber = stream.readLong();
        this._expiryTime = stream.readLong();
        this._consumerName = (String)stream.readObject();
        this._destination = (JmsDestination)stream.readObject();
        super.readExternal(stream);
    }
}

