/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.MessageManagerEventListener;
import org.exolab.jms.messagemgr.MessageMgrException;
import org.exolab.jms.messagemgr.TopicConsumerEndpoint;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

public class MessageMgr
extends BasicService {
    private static final String MM_SERVICE_NAME = "MessageManager";
    private static MessageMgr _instance;
    private static final Object _block;
    private transient HashMap _listeners = new HashMap(1023);
    private long _sequenceNumberGenerator = 0L;
    private int _maximumSize = 2500;
    private long _messagesProcessed;
    private static final Log _log;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$MessageMgr;

    public static MessageMgr createInstance() throws MessageMgrException {
        if (_instance == null) {
            Object object = _block;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new MessageMgr();
                }
            }
        }
        return _instance;
    }

    public static MessageMgr instance() {
        return _instance;
    }

    private MessageMgr() throws MessageMgrException {
        super(MM_SERVICE_NAME);
    }

    public void start() throws ServiceException {
        try {
            DestinationManager.createInstance();
            ConsumerManager.createInstance();
        }
        catch (ServiceException exception) {
            throw exception;
        }
        catch (Exception exception) {
            String msg = "Failed to start MessageMgr";
            _log.error((Object)msg, (Throwable)exception);
            throw new ServiceException(msg + ":" + exception);
        }
    }

    public void run() {
    }

    public synchronized void stop() throws ServiceException {
        try {
            ConsumerManager.instance().destroy();
            DestinationManager.instance().destroy();
            this._listeners.clear();
        }
        catch (Exception error) {
            error.printStackTrace();
            throw new ServiceException("Failed to stop MessageMgr : " + error.toString());
        }
        Object object = _block;
        synchronized (object) {
            _instance = null;
        }
    }

    public void addDestination(JmsDestination destination) throws JMSException {
        if (destination == null) {
            throw new JMSException("Call to addDestination with null object");
        }
        DestinationManager.instance().createDestinationCache(destination);
    }

    public void removeDestination(JmsDestination destination) throws JMSException {
        if (destination == null) {
            throw new JMSException("Call to removeDestination with null object");
        }
        DestinationManager.instance().destroyDestinationCache(destination);
    }

    public boolean exists(JmsDestination destination) {
        return DestinationManager.instance().hasDestinationCache(destination);
    }

    public void add(MessageImpl message) throws JMSException {
        if (message != null) {
            if (message.isPersistent()) {
                this.addPersistentMessage(message);
            } else {
                this.addNonPersistentMessage(message);
            }
        } else {
            _log.error((Object)"Cannot process a null message.");
        }
    }

    void add(Connection connection, MessageImpl message) throws JMSException {
        if (message != null) {
            if (message.isPersistent()) {
                this.addPersistentMessage(connection, message);
            } else {
                this.addNonPersistentMessage(message);
            }
        } else {
            _log.error((Object)"Cannot process a null message.");
        }
    }

    protected void addNonPersistentMessage(MessageImpl message) throws JMSException {
        message.setAcceptedTime(new Date().getTime());
        message.setSequenceNumber(++this._sequenceNumberGenerator);
        message.setReadOnly(true);
        JmsDestination destination = (JmsDestination)message.getJMSDestination();
        if (destination != null) {
            this.notifyOnAddMessage(destination, message);
            ++this._messagesProcessed;
        } else {
            _log.error((Object)"Can't locate destination for message");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addPersistentMessage(MessageImpl message) throws JMSException {
        message.setAcceptedTime(new Date().getTime());
        message.setSequenceNumber(++this._sequenceNumberGenerator);
        message.setReadOnly(true);
        JmsDestination destination = (JmsDestination)message.getJMSDestination();
        if (destination == null) {
            throw new JMSException("Can't process message - JMSDestination is null");
        }
        Connection connection = null;
        Object tm = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                DatabaseService.getAdapter().addMessage(connection, message);
                if (destination instanceof JmsTopic) {
                    ConsumerManager.instance().persistentMessageAdded(connection, message);
                } else {
                    MessageHandleFactory.createPersistentHandle(connection, destination, null, message);
                }
                connection.commit();
                this.notifyOnAddPersistentMessage(null, destination, message);
                ++this._messagesProcessed;
            }
            catch (Exception exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                _log.error((Object)"Failed to make message persistent", (Throwable)exception);
                throw new JMSException("Failed to make message persistent: " + exception.toString());
            }
            Object var8_5 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        connection.close();
        return;
    }

    protected void addPersistentMessage(Connection connection, MessageImpl message) throws JMSException {
        JmsDestination destination = (JmsDestination)message.getJMSDestination();
        if (destination != null) {
            try {
                this.notifyOnAddPersistentMessage(connection, destination, message);
                ++this._messagesProcessed;
            }
            catch (PersistenceException exception) {
                throw new JMSException("Failed in addPersistentMessage : " + ((Throwable)((Object)exception)).toString());
            }
            catch (Exception exception) {
                throw new JMSException("Failed in addPersistentMessage : " + exception.toString());
            }
        } else {
            _log.error((Object)"Can't locate destination for message");
        }
    }

    MessageImpl getMessage(MessageHandle handle) {
        if (handle == null) {
            return null;
        }
        MessageImpl message = null;
        if (handle.getDestination() instanceof JmsTopic) {
            TopicConsumerEndpoint endpoint = (TopicConsumerEndpoint)ConsumerManager.instance().getConsumerEndpoint(handle.getConsumerName());
            if (endpoint != null) {
                message = endpoint.getMessage(handle);
            }
        } else {
            DestinationCache cache = DestinationManager.instance().getDestinationCache(handle.getDestination());
            if (cache != null) {
                message = cache.getMessage(handle);
            }
        }
        return message;
    }

    void checkAndPrepareMessage(MessageImpl message) throws JMSException {
        if (message != null) {
            message.setAcceptedTime(new Date().getTime());
            message.setSequenceNumber(++this._sequenceNumberGenerator);
            message.setReadOnly(true);
            if (message.getJMSDestination() == null) {
                throw new JMSException("Null destination specified in message");
            }
        } else {
            throw new JMSException("checkAndPrepareMessage failed for null message");
        }
    }

    public boolean hasMessages(ConsumerEndpoint consumer) throws JMSException {
        if (consumer == null) {
            throw new JMSException("Can't call hasMessages with null consumer");
        }
        return consumer.getMessageCount() > 0;
    }

    public Iterator getDestinations() {
        return DestinationManager.instance().destinations();
    }

    public Iterator getConsumers(JmsDestination destination) throws JMSException {
        if (destination == null) {
            throw new JMSException("destination is null in getConsumer");
        }
        DestinationCache dest = DestinationManager.instance().getDestinationCache(destination);
        return dest == null ? null : dest.getConsumers();
    }

    public JmsDestination resolve(String name) {
        return DestinationManager.instance().destinationFromString(name);
    }

    public ConsumerEndpoint resolveConsumer(JmsDestination destination, String id) {
        return ConsumerManager.instance().getConsumerEndpoint(id);
    }

    public void setStopped(ConsumerEndpoint consumer, boolean stop) throws JMSException {
    }

    public void addEventListener(JmsDestination destination, MessageManagerEventListener listener) {
        if (destination != null && listener != null) {
            HashMap hashMap = this._listeners;
            synchronized (hashMap) {
                if (!this._listeners.containsKey(destination)) {
                    this._listeners.put(destination, listener);
                }
            }
        }
    }

    public void removeEventListener(JmsDestination destination, MessageManagerEventListener listener) {
        if (destination != null && listener != null) {
            HashMap hashMap = this._listeners;
            synchronized (hashMap) {
                if (this._listeners.containsKey(destination)) {
                    this._listeners.remove(destination);
                }
            }
        }
    }

    boolean notifyOnAddMessage(JmsDestination destination, MessageImpl message) throws JMSException {
        boolean result = false;
        MessageManagerEventListener listener = (MessageManagerEventListener)this._listeners.get(destination);
        result = listener != null ? listener.messageAdded(destination, message) : DestinationManager.instance().messageAdded(destination, message);
        return result;
    }

    void notifyOnRemoveMessage(JmsDestination destination, MessageImpl message) throws JMSException {
        MessageManagerEventListener listener = (MessageManagerEventListener)this._listeners.get(destination);
        if (listener != null) {
            listener.messageRemoved(destination, message);
        } else {
            DestinationManager.instance().messageRemoved(destination, message);
        }
    }

    boolean notifyOnAddPersistentMessage(Connection connection, JmsDestination destination, MessageImpl message) throws JMSException, PersistenceException {
        boolean result = false;
        MessageManagerEventListener listener = (MessageManagerEventListener)this._listeners.get(destination);
        result = listener != null ? listener.persistentMessageAdded(connection, destination, message) : DestinationManager.instance().persistentMessageAdded(connection, destination, message);
        return result;
    }

    void notifyOnRemovePersistentMessage(Connection connection, JmsDestination destination, MessageImpl message) throws JMSException, PersistenceException {
        MessageManagerEventListener listener = (MessageManagerEventListener)this._listeners.get(destination);
        if (listener != null) {
            listener.persistentMessageRemoved(connection, destination, message);
        } else {
            DestinationManager.instance().persistentMessageRemoved(connection, destination, message);
        }
    }

    public int getMaximumSize() {
        return this._maximumSize;
    }

    public void handleDestroyed(MessageHandle handle) {
        if (handle == null) {
            return;
        }
        if (handle.getDestination() instanceof JmsTopic) {
            TopicConsumerEndpoint endpoint = (TopicConsumerEndpoint)ConsumerManager.instance().getConsumerEndpoint(handle.getConsumerName());
            if (endpoint != null) {
                endpoint.deleteMessage(handle);
            }
        } else {
            DestinationCache cache = DestinationManager.instance().getDestinationCache(handle.getDestination());
            if (cache != null) {
                cache.deleteMessage(handle);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _block = new Object();
        _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$MessageMgr == null ? (class$org$exolab$jms$messagemgr$MessageMgr = MessageMgr.class$("org.exolab.jms.messagemgr.MessageMgr")) : class$org$exolab$jms$messagemgr$MessageMgr));
    }
}

