/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.lease.BaseLease;
import org.exolab.jms.lease.LeaseEventListenerIfc;
import org.exolab.jms.lease.LeaseManager;
import org.exolab.jms.lease.MessageLease;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;

public class MessageLeaseHelper
implements LeaseEventListenerIfc {
    private LeaseEventListenerIfc _listener;
    private HashMap _leases = new HashMap();
    private LeaseManager _leaseMgr;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$MessageLeaseHelper == null ? (class$org$exolab$jms$messagemgr$MessageLeaseHelper = MessageLeaseHelper.class$("org.exolab.jms.messagemgr.MessageLeaseHelper")) : class$org$exolab$jms$messagemgr$MessageLeaseHelper));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$MessageLeaseHelper;

    public MessageLeaseHelper(DestinationCache listener) throws PersistenceException {
        this._listener = listener;
        this._leaseMgr = LeaseManager.instance();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                this.init(listener, connection);
                connection.commit();
            }
            catch (PersistenceException exception) {
                SQLHelper.rollback(connection);
                throw exception;
            }
            catch (SQLException exception) {
                SQLHelper.rollback(connection);
                throw new PersistenceException(exception);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public MessageLeaseHelper(Connection connection, DestinationCache listener) throws PersistenceException {
        this._listener = listener;
        this._leaseMgr = LeaseManager.instance();
        this.init(listener, connection);
    }

    public void addLease(MessageImpl message) {
        HashMap hashMap = this._leases;
        synchronized (hashMap) {
            if (!this._leases.containsKey(message.getMessageId())) {
                try {
                    long expiry = message.getJMSExpiration();
                    if (expiry > 0L) {
                        MessageHandle handle = MessageHandleFactory.getHandle(message);
                        long duration = expiry - System.currentTimeMillis();
                        MessageLease lease = this._leaseMgr.createMessageLease(handle, duration <= 0L ? 1L : duration, this);
                        this._leases.put(handle.getMessageId(), lease);
                    }
                }
                catch (JMSException exception) {
                    _log.error((Object)"Failed to create lease", (Throwable)exception);
                }
            }
        }
    }

    public void addLease(MessageHandle handle) {
        HashMap hashMap = this._leases;
        synchronized (hashMap) {
            long expiry;
            if (!this._leases.containsKey(handle.getMessageId()) && (expiry = handle.getExpiryTime()) != 0L) {
                long duration = expiry - System.currentTimeMillis();
                MessageLease lease = this._leaseMgr.createMessageLease(handle, duration <= 0L ? 1L : duration, this);
                this._leases.put(handle.getMessageId(), lease);
            }
        }
    }

    public void removeLease(MessageImpl message) {
        block5: {
            try {
                MessageHandle handle = MessageHandleFactory.getHandle(message);
                if (handle == null) break block5;
                HashMap hashMap = this._leases;
                synchronized (hashMap) {
                    this._leases.remove(handle.getMessageId());
                }
            }
            catch (JMSException exception) {
                _log.error((Object)"Failed to remove lease", (Throwable)exception);
            }
        }
    }

    public void clear() {
        Object[] leases = null;
        HashMap hashMap = this._leases;
        synchronized (hashMap) {
            leases = this._leases.values().toArray();
            this._leases.clear();
        }
        int i = 0;
        while (i < leases.length) {
            BaseLease lease = (BaseLease)leases[i];
            this._leaseMgr.removeLease(lease);
            ++i;
        }
    }

    public void onLeaseExpired(Object handle) {
        HashMap hashMap = this._leases;
        synchronized (hashMap) {
            this._leases.remove(((MessageHandle)handle).getMessageId());
        }
        this._listener.onLeaseExpired(handle);
    }

    protected void init(DestinationCache listener, Connection connection) throws PersistenceException {
        Vector handles;
        if (DatabaseService.getAdapter().checkDestination(connection, listener.getDestinationByName()) && (handles = DatabaseService.getAdapter().getNonExpiredMessages(connection, listener.getDestination())) != null) {
            Enumeration iter = handles.elements();
            while (iter.hasMoreElements()) {
                PersistentMessageHandle handle = (PersistentMessageHandle)iter.nextElement();
                this.addLease(handle);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

