/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DurableConsumerEndpoint;
import org.exolab.jms.messagemgr.MessageMgr;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.QueueDestinationCache;
import org.exolab.jms.messagemgr.TransientMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

public class MessageHandleFactory {
    public static MessageHandle getHandle(MessageImpl message) throws JMSException {
        MessageHandle handle = null;
        handle = message.isPersistent() ? new PersistentMessageHandle(message) : new TransientMessageHandle(message);
        return handle;
    }

    public static MessageHandle getHandle(QueueDestinationCache queue, MessageImpl message) throws JMSException {
        MessageHandle handle = null;
        if (message.getJMSDeliveryMode() == 2) {
            PersistentMessageHandle phandle = new PersistentMessageHandle(message);
            phandle.setConsumerName(queue.getDestination().getName());
            phandle.setDestination(queue.getDestination());
            handle = phandle;
        } else {
            handle = new TransientMessageHandle(message);
        }
        return handle;
    }

    public static MessageHandle getHandle(JmsDestination dest, String name, MessageImpl message) throws JMSException {
        MessageHandle handle = null;
        if (message.getJMSDeliveryMode() == 2) {
            PersistentMessageHandle phandle = new PersistentMessageHandle(message);
            phandle.setDestination(dest);
            if (dest instanceof JmsQueue) {
                phandle.setConsumerName(dest.getName());
            } else {
                phandle.setConsumerName(name);
            }
            handle = phandle;
        } else {
            handle = new TransientMessageHandle(message);
        }
        return handle;
    }

    public static MessageHandle getHandle(ConsumerEndpoint consumer, MessageImpl message) throws JMSException {
        MessageHandle handle = null;
        if (message.getJMSDeliveryMode() == 2) {
            if (consumer instanceof DurableConsumerEndpoint) {
                PersistentMessageHandle phandle = new PersistentMessageHandle(message);
                DurableConsumerEndpoint durable = (DurableConsumerEndpoint)consumer;
                phandle.setConsumerName(durable.getName());
                phandle.setDestination((JmsDestination)message.getJMSDestination());
                handle = phandle;
            } else {
                handle = new TransientMessageHandle(message);
            }
        } else {
            handle = new TransientMessageHandle(message);
        }
        return handle;
    }

    public static MessageHandle createHandle(QueueDestinationCache queue, MessageImpl message) throws JMSException {
        return new TransientMessageHandle(message);
    }

    public static MessageHandle createHandle(DurableConsumerEndpoint durable, MessageImpl message) throws JMSException {
        return new TransientMessageHandle(message);
    }

    public static MessageHandle createHandle(JmsDestination dest, String name, MessageImpl message) throws JMSException {
        return new TransientMessageHandle(message);
    }

    public static MessageHandle createPersistentHandle(TransientMessageHandle handle) throws JMSException {
        PersistentMessageHandle phandle = new PersistentMessageHandle();
        phandle.setMessageId(handle.getMessageId());
        phandle.setPriority(handle.getPriority());
        phandle.setDelivered(handle.getDelivered());
        phandle.setDestination(handle.getDestination());
        phandle.setAcceptedTime(handle.getAcceptedTime());
        phandle.setExpiryTime(handle.getExpiryTime());
        phandle.setSequenceNumber(handle.getSequenceNumber());
        phandle.setClientId(handle.getClientId());
        return phandle;
    }

    public static MessageHandle createPersistentHandle(Connection connection, QueueDestinationCache queue, MessageImpl message) throws JMSException, PersistenceException {
        PersistentMessageHandle handle = new PersistentMessageHandle(message);
        handle.setConsumerName(queue.getDestination().getName());
        handle.setDestination(queue.getDestination());
        DatabaseService.getAdapter().addMessageHandle(connection, handle);
        return handle;
    }

    public static MessageHandle createPersistentHandle(Connection connection, DurableConsumerEndpoint durable, MessageImpl message) throws JMSException, PersistenceException {
        PersistentMessageHandle handle = new PersistentMessageHandle(message);
        handle.setConsumerName(durable.getName());
        handle.setDestination(durable.getDestination());
        DatabaseService.getAdapter().addMessageHandle(connection, handle);
        return handle;
    }

    public static MessageHandle createPersistentHandle(Connection connection, JmsDestination dest, String name, MessageImpl message) throws JMSException, PersistenceException {
        PersistentMessageHandle handle = new PersistentMessageHandle(message);
        handle.setDestination(dest);
        if (dest instanceof JmsQueue) {
            handle.setConsumerName(dest.getName());
        } else {
            handle.setConsumerName(name);
        }
        DatabaseService.getAdapter().addMessageHandle(connection, handle);
        return handle;
    }

    public static void destroyPersistentHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        DatabaseService.getAdapter().removeMessageHandle(connection, handle);
        MessageMgr.instance().handleDestroyed(handle);
    }

    public static void destroyPersistentHandle(Connection connection, JmsDestination destination, String name, MessageImpl message) throws JMSException, PersistenceException {
        if (message.isPersistent()) {
            PersistentMessageHandle handle = (PersistentMessageHandle)MessageHandleFactory.getHandle(destination, name, message);
            MessageHandleFactory.destroyPersistentHandle(connection, handle);
        }
    }

    public static void updatePersistentHandle(Connection connection, PersistentMessageHandle handle) throws PersistenceException {
        DatabaseService.getAdapter().updateMessageHandle(connection, handle);
    }
}

