/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageHandleComparator;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.MessageQueue;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.TransientMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

class MessageCache {
    private transient Map _transient = Collections.synchronizedMap(new HashMap(1023));
    private transient Map _persistent = Collections.synchronizedMap(new HashMap(1023));
    private MessageQueue _handles = new MessageQueue(new MessageHandleComparator());
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$MessageCache == null ? (class$org$exolab$jms$messagemgr$MessageCache = MessageCache.class$("org.exolab.jms.messagemgr.MessageCache")) : class$org$exolab$jms$messagemgr$MessageCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$MessageCache;

    MessageCache() {
    }

    void addMessage(MessageId id, MessageImpl message) {
        if (message.isPersistent()) {
            this.addPersistentMessage(message);
        } else {
            this.addNonPersistentMessage(message);
        }
    }

    void addMessage(MessageHandle handle, MessageImpl message) {
        this.addMessage(handle.getMessageId(), message);
        this.addHandle(handle);
    }

    void addHandle(MessageHandle handle) {
        this._handles.add(handle);
    }

    MessageImpl removeMessage(MessageId id) {
        MessageImpl message = this.removePersistentMessage(id);
        if (message == null) {
            message = this.removeNonPersistentMessage(id);
        }
        return message;
    }

    boolean removeHandle(MessageHandle handle) {
        return this._handles.remove(handle);
    }

    final MessageHandle removeFirstHandle() {
        return (MessageHandle)this._handles.removeFirst();
    }

    Object[] getHandleArray() {
        return this._handles.toArray();
    }

    final boolean containsHandle(MessageHandle handle) {
        return this._handles.contains(handle);
    }

    /*
     * Unable to fully structure code
     */
    MessageImpl getMessage(MessageHandle handle) {
        if (handle == null) {
            return null;
        }
        message = null;
        id = handle.getMessageId();
        if (handle.isPersistent()) {
            message = (MessageImpl)this._persistent.get(id);
            if (message == null) {
                phandle = null;
                if (handle instanceof PersistentMessageHandle) {
                    phandle = (PersistentMessageHandle)handle;
                } else {
                    try {
                        phandle = (PersistentMessageHandle)MessageHandleFactory.createPersistentHandle((TransientMessageHandle)handle);
                    }
                    catch (Exception exception) {
                        MessageCache._log.error((Object)"Failed to retrieve message", (Throwable)exception);
                    }
                }
                if (phandle != null) {
                    block33: {
                        adapter = DatabaseService.getAdapter();
                        connection = null;
                        try {
                            connection = DatabaseService.getConnection();
                            message = adapter.getMessage(connection, phandle.getMessageId().getId());
                            connection.commit();
                            var10_9 = null;
                            ** if (connection == null) goto lbl-1000
                        }
                        catch (Throwable var9_21) {
                            var10_12 = null;
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Exception nested) {
                                    // empty catch block
                                }
                            }
                            throw var9_21;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                connection.close();
                            }
                            catch (Exception nested) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block33;
                            catch (PersistenceException exception) {
                                if (connection != null) {
                                    try {
                                        connection.rollback();
                                    }
                                    catch (Exception nested) {
                                        // empty catch block
                                    }
                                }
                                MessageCache._log.error((Object)"Failed to retrieve message", (Throwable)exception);
                                var10_10 = null;
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Exception nested) {}
                                }
                                break block33;
                            }
                            catch (Exception exception) {
                                MessageCache._log.error((Object)"Failed to retrieve message", (Throwable)exception);
                                var10_11 = null;
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Exception nested) {}
                                }
                            }
                        }
                    }
                    if (message != null) {
                        var7_18 = this._persistent;
                        synchronized (var7_18) {
                            this._persistent.put(id, message);
                        }
                    }
                }
            }
        } else {
            message = (MessageImpl)this._transient.get(id);
        }
        if (message != null && !message.getReadOnly()) {
            try {
                message.setReadOnly(true);
            }
            catch (JMSException exception) {
                MessageCache._log.error((Object)exception);
                message = null;
            }
        }
        return message;
    }

    void clear() {
        this._transient.clear();
        this._persistent.clear();
        this._handles.clear();
    }

    void clearPersistentMessages() {
        this._persistent.clear();
    }

    void clearTransientMessages() {
        this._transient.clear();
    }

    private void addNonPersistentMessage(MessageImpl message) {
        Map map = this._transient;
        synchronized (map) {
            this._transient.put(message.getMessageId(), message);
        }
    }

    private MessageImpl removeNonPersistentMessage(MessageId id) {
        MessageImpl message = null;
        Map map = this._transient;
        synchronized (map) {
            message = (MessageImpl)this._transient.remove(id);
        }
        return message;
    }

    private MessageImpl removePersistentMessage(MessageId id) {
        MessageImpl message = null;
        Map map = this._persistent;
        synchronized (map) {
            message = (MessageImpl)this._persistent.remove(id);
        }
        return message;
    }

    private void addPersistentMessage(MessageImpl message) {
        Map map = this._persistent;
        synchronized (map) {
            this._persistent.put(message.getMessageId(), message);
        }
    }

    public int getTransientCount() {
        return this._transient.size();
    }

    public int getPersistentCount() {
        return this._persistent.size();
    }

    public int getHandleCount() {
        return this._handles.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

