/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.ServiceException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.AdministeredDestinations;
import org.exolab.jms.config.AdministeredQueue;
import org.exolab.jms.config.AdministeredTopic;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.MessageManagerConfiguration;
import org.exolab.jms.config.Subscriber;
import org.exolab.jms.gc.GarbageCollectable;
import org.exolab.jms.gc.GarbageCollectionService;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.ContextHelper;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationEventListener;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.MessageManagerEventListener;
import org.exolab.jms.messagemgr.QueueDestinationCache;
import org.exolab.jms.messagemgr.TopicDestinationCache;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.server.NamingHelper;

public class DestinationManager
implements MessageManagerEventListener,
GarbageCollectable {
    private Map _caches = Collections.synchronizedMap(new HashMap());
    private HashMap _destinationCache = new HashMap();
    private final int _maxCacheSize;
    private LinkedList _wildcardDestinations = new LinkedList();
    private LinkedList _listeners = new LinkedList();
    private static volatile DestinationManager _instance = null;
    private InitialContext _context = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$DestinationManager == null ? (class$org$exolab$jms$messagemgr$DestinationManager = DestinationManager.class$("org.exolab.jms.messagemgr.DestinationManager")) : class$org$exolab$jms$messagemgr$DestinationManager));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationManager;

    private DestinationManager() throws ServiceException {
        MessageManagerConfiguration config = ConfigurationManager.getConfig().getMessageManagerConfiguration();
        this._maxCacheSize = config.getDestinationCacheSize();
        this.init();
        GarbageCollectionService.instance().register(this);
    }

    public static DestinationManager createInstance() throws ServiceException {
        _instance = new DestinationManager();
        return _instance;
    }

    public static DestinationManager instance() {
        return _instance;
    }

    public synchronized DestinationCache createDestinationCache(JmsDestination dest) {
        return this.createDestinationCache(null, dest);
    }

    public synchronized DestinationCache createDestinationCache(Connection connection, JmsDestination dest) {
        DestinationCache cache = (DestinationCache)this._caches.get(dest);
        if (cache == null) {
            try {
                if (dest instanceof JmsTopic) {
                    cache = connection != null ? new TopicDestinationCache(connection, (JmsTopic)dest) : new TopicDestinationCache((JmsTopic)dest);
                } else if (dest instanceof JmsQueue) {
                    cache = connection != null ? new QueueDestinationCache(connection, (JmsQueue)dest) : new QueueDestinationCache((JmsQueue)dest);
                }
                cache.setMaximumSize(this._maxCacheSize);
                this.notifyDestinationAdded(dest, cache);
                this._caches.put(dest, cache);
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to createDestinationCache", (Throwable)exception);
            }
        }
        return cache;
    }

    public synchronized void destroyDestinationCache(DestinationCache cache) {
        this.destroyDestinationCache(cache.getDestination());
    }

    public synchronized void destroyDestinationCache(String name) {
        Iterator iter = this._caches.keySet().iterator();
        while (iter.hasNext()) {
            JmsDestination dest = (JmsDestination)iter.next();
            if (!dest.getName().equals(name)) continue;
            this.destroyDestinationCache(dest);
            break;
        }
    }

    public synchronized void destroyDestinationCache(JmsDestination dest) {
        DestinationCache cache = (DestinationCache)this._caches.remove(dest);
        if (cache != null) {
            cache.destroy();
            this.notifyDestinationRemoved(dest, cache);
        }
    }

    public synchronized JmsDestination destinationFromString(String name) {
        return (JmsDestination)this._destinationCache.get(name);
    }

    void addDestinationEventListener(DestinationEventListener listener) {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    void removeDestinationEventListener(DestinationEventListener listener) {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            this._listeners.remove(listener);
        }
    }

    public DestinationCache getDestinationCache(JmsDestination dest) {
        return (DestinationCache)this._caches.get(dest);
    }

    public DestinationCache getDestinationCache(String dest) {
        return this.getDestinationCache(this.destinationFromString(dest));
    }

    public DestinationCache getDestinationCache(MessageImpl message) {
        DestinationCache cache = null;
        if (message != null) {
            try {
                cache = this.getDestinationCache((JmsDestination)message.getJMSDestination());
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return cache;
    }

    public boolean hasDestinationCache(JmsDestination dest) {
        return this._caches.containsKey(dest);
    }

    public synchronized void createDestination(JmsDestination destination) {
        this.addToDestinationCache(destination);
    }

    public synchronized boolean createAdministeredDestination(JmsDestination dest) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createAdministeredDestination(dest=" + dest + ")"));
        }
        boolean success = true;
        boolean queue = dest instanceof JmsQueue;
        PersistenceAdapter adapter = DatabaseService.getAdapter();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                if (!adapter.checkDestination(connection, dest.getName())) {
                    adapter.addDestination(connection, dest.getName(), queue);
                    this.addToDestinationCache(dest);
                    try {
                        dest.setPersistent(true);
                        ContextHelper.rebind(DestinationManager.getContext(), dest.getName(), dest);
                    }
                    catch (NamingException exception) {
                        String msg = "Failed to add destination " + dest.getName() + " to JNDI context";
                        _log.error((Object)msg, (Throwable)exception);
                        throw new JMSException(msg + ": " + exception.getMessage());
                    }
                } else {
                    success = false;
                }
                connection.commit();
            }
            catch (JMSException exception) {
                SQLHelper.rollback(connection);
                throw exception;
            }
            catch (Exception exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to create administered destination" + dest.getName();
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg + ": " + exception.getMessage());
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return success;
    }

    public synchronized void deleteAdministeredDestination(JmsDestination dest) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("deleteAdministeredDestination(dest=" + dest + ")"));
        }
        boolean success = false;
        boolean queue = dest instanceof JmsQueue;
        ConsumerManager consumerMgr = ConsumerManager.instance();
        if (!queue) {
            if (consumerMgr.hasActiveDurableConsumers(dest)) {
                throw new JMSException("Cannot delete the administered destination " + dest + " since there are active durable consumers.");
            }
            consumerMgr.removeDurableConsumers(dest);
        }
        consumerMgr.cleanUnreferencedEndpoints(dest);
        int active = consumerMgr.getEndpointsForDest(dest).size();
        if (active > 0) {
            throw new JMSException("Cannot delete the administered destination" + dest + " since there are " + active + " active endpoints.");
        }
        try {
            DestinationManager.getContext().unbind(dest.getName());
        }
        catch (NamingException error) {
            _log.error((Object)("Failed to remove destination " + dest.getName() + " from JNDI"), (Throwable)error);
        }
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                DatabaseService.getAdapter().removeDestination(connection, dest.getName());
                this.destroyDestinationCache(dest);
                this.removeFromDestinationCache(dest);
                connection.commit();
            }
            catch (PersistenceException exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to remove destination " + dest.getName();
                _log.error((Object)msg, (Throwable)((Object)exception));
                throw new JMSException(msg + ":" + ((Throwable)((Object)exception)).getMessage());
            }
            catch (SQLException exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to remove destination " + dest.getName();
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg + ":" + exception.getMessage());
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public Iterator destinationNames() {
        return this._destinationCache.values().iterator();
    }

    public Iterator destinations() {
        return this._caches.values().iterator();
    }

    public void registerConfiguredAdministeredDestinations() {
        AdministeredDestinations destinations = ConfigurationManager.getConfig().getAdministeredDestinations();
        if (destinations != null) {
            int count = destinations.getAdministeredTopicCount();
            int index = 0;
            while (index < count) {
                AdministeredTopic topic = destinations.getAdministeredTopic(index);
                JmsTopic destination = new JmsTopic(topic.getName());
                destination.setPersistent(true);
                try {
                    this.createAdministeredDestination(destination);
                    int scount = topic.getSubscriberCount();
                    ConsumerManager mgr = ConsumerManager.instance();
                    int sindex = 0;
                    while (sindex < scount) {
                        Subscriber subscriber = topic.getSubscriber(sindex);
                        if (!mgr.exists(subscriber.getName())) {
                            mgr.createDurableConsumer(destination, subscriber.getName());
                        }
                        ++sindex;
                    }
                }
                catch (JMSException exception) {
                    _log.error((Object)("Failed to register persistent topic " + topic.getName()), (Throwable)exception);
                }
                ++index;
            }
            count = destinations.getAdministeredQueueCount();
            int index2 = 0;
            while (index2 < count) {
                AdministeredQueue queue = destinations.getAdministeredQueue(index2);
                JmsQueue destination = new JmsQueue(queue.getName());
                destination.setPersistent(true);
                try {
                    this.createAdministeredDestination(destination);
                }
                catch (JMSException exception) {
                    _log.error((Object)("Failed to register persistent queue " + queue.getName()), (Throwable)exception);
                }
                ++index2;
            }
        }
    }

    public synchronized boolean messageAdded(JmsDestination destination, MessageImpl message) {
        boolean result = false;
        try {
            if (destination instanceof JmsTopic) {
                if (ConsumerManager.instance().hasActiveConsumers(destination)) {
                    if (!this.destinationExists(destination)) {
                        this.createDestination(destination);
                    }
                    DestinationCache cache = this.createDestinationCache(destination);
                    result = cache.messageAdded(destination, message);
                }
            } else {
                if (!this.destinationExists(destination)) {
                    this.createDestination(destination);
                }
                DestinationCache cache = this.createDestinationCache(destination);
                result = cache.messageAdded(destination, message);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Exception in DestinationManager.messageAdded", (Throwable)exception);
        }
        return result;
    }

    public void messageRemoved(JmsDestination destination, MessageImpl message) {
    }

    public synchronized boolean persistentMessageAdded(Connection connection, JmsDestination destination, MessageImpl message) throws PersistenceException {
        boolean result = false;
        try {
            ConsumerManager manager;
            if (destination instanceof JmsTopic && (manager = ConsumerManager.instance()).hasActiveConsumers(destination)) {
                DestinationCache cache = this.createDestinationCache(connection, destination);
                result = cache.persistentMessageAdded(connection, destination, message);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PersistenceException("Exception in DestinationManager.messageAdded " + exception.toString());
        }
        return result;
    }

    public void persistentMessageRemoved(Connection connection, JmsDestination destination, MessageImpl message) throws PersistenceException {
        try {
            if (destination instanceof JmsTopic) {
                Vector names = ConsumerManager.instance().getDurableConsumersForDest((JmsTopic)destination);
                while (names.size() > 0) {
                    String name = (String)names.remove(0);
                    MessageHandleFactory.destroyPersistentHandle(connection, destination, name, message);
                }
            } else {
                MessageHandleFactory.destroyPersistentHandle(connection, destination, null, message);
            }
        }
        catch (PersistenceException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PersistenceException("Exception in DestinationManager.messageRemoved " + exception.toString());
        }
    }

    public synchronized void collectGarbage(boolean aggressive) {
        int gc_caches = 0;
        int gc_destinations = 0;
        Object[] caches = this._caches.values().toArray();
        int index = 0;
        while (index < caches.length) {
            DestinationCache cache = (DestinationCache)caches[index];
            if (cache.canDestroy()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Garbage collecting destination cache=" + cache));
                }
                this.destroyDestinationCache(cache);
                ++gc_caches;
            } else {
                cache.collectGarbage(aggressive);
            }
            ++index;
        }
        Iterator destinations = this._destinationCache.values().iterator();
        Vector<JmsDestination> to_delete = new Vector<JmsDestination>();
        while (destinations.hasNext()) {
            JmsDestination dest = (JmsDestination)destinations.next();
            if (dest.getPersistent() || this._caches.containsKey(dest)) continue;
            to_delete.add(dest);
            ++gc_destinations;
        }
        Enumeration todel = to_delete.elements();
        while (todel.hasMoreElements()) {
            this._destinationCache.remove(((JmsDestination)todel.nextElement()).getName());
        }
        _log.info((Object)("DMGC Collected " + gc_caches + " caches, " + this._caches.size() + " remaining."));
        _log.info((Object)("DMGC Collected " + gc_destinations + " destinations, " + this._destinationCache.size() + " remaining."));
    }

    synchronized HashMap getTopicDestinationCaches(JmsTopic topic) {
        HashMap result = new HashMap();
        Iterator iter = this._caches.keySet().iterator();
        while (iter.hasNext()) {
            JmsDestination dest = (JmsDestination)iter.next();
            if (!(dest instanceof JmsTopic) || !topic.match((JmsTopic)dest)) continue;
            result.put(dest, this._caches.get(dest));
        }
        return result;
    }

    public synchronized void destroy() {
        Object[] dests = this._caches.keySet().toArray();
        int index = 0;
        while (index < dests.length) {
            this.destroyDestinationCache((JmsDestination)dests[index]);
            ++index;
        }
        this._caches.clear();
        this._caches = null;
        this._destinationCache.clear();
        this._destinationCache = null;
        this._listeners.clear();
        this._listeners = null;
        this._context = null;
        _instance = null;
    }

    public boolean isAdministeredDestination(String name) {
        boolean result = false;
        JmsDestination dest = (JmsDestination)this._destinationCache.get(name);
        if (dest != null && dest.getPersistent()) {
            result = true;
        }
        return result;
    }

    public boolean isMessageForAdministeredDestination(MessageImpl msg) {
        boolean result;
        block5: {
            result = false;
            try {
                JmsDestination mdest = (JmsDestination)msg.getJMSDestination();
                JmsDestination dest = (JmsDestination)this._destinationCache.get(mdest.getName());
                if (dest == null) break block5;
                if (dest.getPersistent()) {
                    result = true;
                    break block5;
                }
                if (!(mdest instanceof JmsTopic)) break block5;
                Object[] dests = this._wildcardDestinations.toArray();
                int index = 0;
                while (index < dests.length) {
                    JmsTopic adest = (JmsTopic)dests[index];
                    if (adest.match((JmsTopic)mdest) && adest.getPersistent()) {
                        result = true;
                        break;
                    }
                    ++index;
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return result;
    }

    void addToDestinationCache(JmsDestination destination) {
        HashMap hashMap = this._destinationCache;
        synchronized (hashMap) {
            if (!this._destinationCache.containsKey(destination.getName())) {
                this._destinationCache.put(destination.getName(), destination);
                if (destination instanceof JmsTopic && ((JmsTopic)destination).isWildCard()) {
                    this._wildcardDestinations.add(destination);
                }
            }
        }
    }

    void removeFromDestinationCache(JmsDestination destination) {
        HashMap hashMap = this._destinationCache;
        synchronized (hashMap) {
            if (this._destinationCache.remove(destination.getName()) != null && destination instanceof JmsTopic && ((JmsTopic)destination).isWildCard()) {
                this._wildcardDestinations.remove(destination);
            }
        }
    }

    public boolean destinationExists(JmsDestination destination) {
        return this._destinationCache.containsKey(destination.getName());
    }

    protected void init() throws ServiceException {
        Connection connection = null;
        Object tm = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                Enumeration iter = DatabaseService.getAdapter().getAllDestinations(connection);
                connection.commit();
                while (iter.hasMoreElements()) {
                    JmsDestination dest = (JmsDestination)iter.nextElement();
                    this.addToDestinationCache(dest);
                    try {
                        dest.setPersistent(true);
                        ContextHelper.rebind(DestinationManager.getContext(), dest.getName(), dest);
                    }
                    catch (NamingException error) {
                        throw new ServiceException("Failed to add destination " + dest.getName() + " to JNDI", (Throwable)error);
                    }
                }
            }
            catch (PersistenceException exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to initialise DestinationManager";
                _log.error((Object)msg, (Throwable)((Object)exception));
                throw exception;
            }
            catch (SQLException exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to initialise DestinationManager";
                _log.error((Object)msg, (Throwable)exception);
                throw new ServiceException(msg, (Throwable)exception);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    private void notifyDestinationAdded(JmsDestination dest, DestinationCache cache) {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            Iterator iter = this._listeners.iterator();
            while (iter.hasNext()) {
                ((DestinationEventListener)iter.next()).destinationAdded(dest, cache);
            }
        }
    }

    private void notifyDestinationRemoved(JmsDestination dest, DestinationCache cache) {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            Iterator iter = this._listeners.iterator();
            while (iter.hasNext()) {
                ((DestinationEventListener)iter.next()).destinationRemoved(dest, cache);
            }
        }
    }

    private static Context getContext() throws NamingException {
        return NamingHelper.getInitialContext(ConfigurationManager.getConfig());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DestinationEntry {
        public JmsDestination _destination = null;
        public boolean _administered = false;

        DestinationEntry(JmsDestination dest, boolean administered) {
            this._destination = dest;
            this._administered = administered;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof DestinationEntry) {
                result = this._destination.equals(((DestinationEntry)obj)._destination);
            }
            return result;
        }
    }
}

