/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.Identifiable;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.gc.GarbageCollectable;
import org.exolab.jms.lease.LeaseEventListenerIfc;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.CacheEvictionPolicy;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.FailedToInitializeException;
import org.exolab.jms.messagemgr.MessageCache;
import org.exolab.jms.messagemgr.MessageLeaseHelper;
import org.exolab.jms.messagemgr.MessageManagerEventListener;
import org.exolab.jms.messagemgr.MessageMgr;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.util.UUID;

public abstract class DestinationCache
implements MessageManagerEventListener,
Identifiable,
LeaseEventListenerIfc,
GarbageCollectable {
    private String _id;
    private MessageCache _cache = new MessageCache();
    private int _maximumSize = Integer.MAX_VALUE;
    protected List _consumers = Collections.synchronizedList(new LinkedList());
    protected MessageLeaseHelper _leaseHelper = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$DestinationCache == null ? (class$org$exolab$jms$messagemgr$DestinationCache = DestinationCache.class$("org.exolab.jms.messagemgr.DestinationCache")) : class$org$exolab$jms$messagemgr$DestinationCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationCache;

    DestinationCache() {
        this._id = UUID.next();
    }

    void init() throws FailedToInitializeException {
        try {
            this._leaseHelper = new MessageLeaseHelper(this);
        }
        catch (PersistenceException exception) {
            String msg = "Failed to initialise destination cache";
            _log.error((Object)msg, (Throwable)((Object)exception));
            throw new FailedToInitializeException(msg + ":" + ((Throwable)((Object)exception)).getMessage());
        }
        MessageMgr.instance().addEventListener(this.getDestination(), this);
    }

    void init(Connection connection) throws FailedToInitializeException {
        MessageMgr.instance().addEventListener(this.getDestination(), this);
        try {
            this._leaseHelper = new MessageLeaseHelper(connection, this);
        }
        catch (Exception exception) {
            throw new FailedToInitializeException("Error initialising " + exception.toString());
        }
    }

    public void setMaximumSize(int size) {
        this._maximumSize = size;
    }

    public int getMaximumSize() {
        return this._maximumSize;
    }

    public abstract JmsDestination getDestination();

    public String getDestinationByName() {
        return this.getDestination().getName();
    }

    public void setCacheEvictionPolicy(CacheEvictionPolicy policy) {
    }

    public boolean registerConsumer(ConsumerEndpoint consumer) {
        boolean result = false;
        if (consumer.getDestination().equals(this.getDestination()) && !this._consumers.contains(consumer)) {
            this._consumers.add(consumer);
            consumer.setMaximumSize(this.getMaximumSize());
            result = true;
        }
        return result;
    }

    public void unregisterConsumer(ConsumerEndpoint consumer) {
        if (this._consumers.contains(consumer)) {
            this._consumers.remove(consumer);
        }
    }

    public Iterator getConsumers() {
        return this._consumers.iterator();
    }

    Object[] getConsumersByArray() {
        return this._consumers.toArray();
    }

    public abstract boolean messageAdded(JmsDestination var1, MessageImpl var2);

    public abstract void messageRemoved(JmsDestination var1, MessageImpl var2);

    public int getMessageCount() {
        return this._cache.getHandleCount();
    }

    abstract boolean notifyOnAddMessage(MessageImpl var1);

    abstract void notifyOnRemoveMessage(MessageImpl var1);

    boolean notifyOnAddPersistentMessage(Connection connection, MessageImpl message) throws PersistenceException {
        return true;
    }

    void notifyOnRemovePersistentMessage(Connection connection, MessageImpl message) throws PersistenceException {
    }

    abstract boolean hasActiveConsumers();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onLeaseExpired(Object leasedObject) {
        if (leasedObject == null) return;
        MessageHandle handle = (MessageHandle)leasedObject;
        MessageImpl message = this.resolveExpiredMessage(handle);
        if (!(handle instanceof PersistentMessageHandle)) {
            this.messageRemoved(this.getDestination(), message);
            return;
        }
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                this.persistentMessageRemoved(connection, this.getDestination(), message);
                connection.commit();
            }
            catch (Exception exception) {
                SQLHelper.rollback(connection);
                _log.error((Object)"Failure in onLeaseExpired", (Throwable)exception);
                Object var7_6 = null;
                SQLHelper.close(connection);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public abstract boolean canDestroy();

    void checkMessageExpiry(MessageImpl message) {
        if (message != null) {
            this._leaseHelper.addLease(message);
        }
    }

    synchronized void destroy() {
        this._cache.clear();
        this._consumers.clear();
        MessageMgr.instance().removeEventListener(this.getDestination(), this);
        this._leaseHelper.clear();
    }

    public void shutdown() {
        this.destroy();
    }

    void addMessage(MessageHandle handle) {
        handle.setConsumerName(this.getDestination().getName());
        this._cache.addHandle(handle);
    }

    void addMessage(MessageHandle handle, MessageImpl message) {
        handle.setConsumerName(this.getDestination().getName());
        this._cache.addMessage(handle, message);
    }

    MessageImpl getMessage(MessageHandle handle) {
        return this._cache.getMessage(handle);
    }

    boolean removeMessage(MessageHandle handle) {
        return this._cache.removeHandle(handle);
    }

    final MessageHandle removeFirstMessage() {
        return this._cache.removeFirstHandle();
    }

    final Object[] toMessageArray() {
        return this._cache.getHandleArray();
    }

    void deleteMessage(MessageHandle handle) {
        this._cache.removeMessage(handle.getMessageId());
    }

    public String getId() {
        return this._id;
    }

    public void collectGarbage(boolean aggressive) {
        if (aggressive) {
            this._cache.clearPersistentMessages();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Evicted all persistent messages from cache " + this.getDestination().getName()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("DESTCACHE -" + this.getDestination().getName() + " Messages: P[" + this._cache.getPersistentCount() + "] T[" + this._cache.getTransientCount() + "] Handles: [" + this._cache.getHandleCount() + "]"));
        }
    }

    protected MessageImpl resolveExpiredMessage(MessageHandle handle) {
        return handle.getMessage();
    }

    public abstract void persistentMessageRemoved(Connection var1, JmsDestination var2, MessageImpl var3) throws PersistenceException;

    public abstract boolean persistentMessageAdded(Connection var1, JmsDestination var2, MessageImpl var3) throws PersistenceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

