/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.exolab.jms.client.JmsDestination;

class ContextHelper {
    ContextHelper() {
    }

    public static void rebind(Context context, String name, JmsDestination destination) throws NamingException {
        Object object;
        CompositeName composite = ContextHelper.getCompositeName(name);
        Context subcontext = context;
        String component = null;
        int i = 0;
        while (i < composite.size() - 1) {
            component = composite.get(i);
            if (component.length() == 0) {
                throw new InvalidNameException("'" + name + "' is not a valid name");
            }
            object = null;
            try {
                object = subcontext.lookup(component);
                if (!(object instanceof Context)) {
                    String subname = "";
                    int j = 0;
                    while (j <= i) {
                        if (j > 0) {
                            subname = subname + ".";
                        }
                        subname = subname + composite.get(j);
                        ++j;
                    }
                    throw new NameAlreadyBoundException("'" + subname + "' is already bound");
                }
                subcontext = (Context)object;
            }
            catch (NameNotFoundException exception) {
                subcontext = subcontext.createSubcontext(component);
            }
            ++i;
        }
        component = composite.get(composite.size() - 1);
        if (component.length() == 0) {
            throw new InvalidNameException("'" + name + "' is not a valid name");
        }
        try {
            object = subcontext.lookup(component);
            if (object instanceof Context) {
                throw new NameAlreadyBoundException("'" + name + "' is already bound");
            }
        }
        catch (NameNotFoundException ignore) {
        }
        catch (NamingException exception) {
            // empty catch block
        }
        subcontext.rebind(component, (Object)destination);
    }

    public static void unbind(Context context, String name) throws NamingException {
        try {
            Object object = context.lookup(name);
            if (!(object instanceof JmsDestination)) {
                throw new NamingException("Cannot unbind name='" + name + "': it does not refer to a " + "Destination");
            }
            context.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private static CompositeName getCompositeName(String name) throws NamingException {
        CompositeName composite = new CompositeName(name.replace('.', '/'));
        if (composite.size() == 0) {
            throw new InvalidNameException("'" + name + "' is not a valid name");
        }
        return composite;
    }
}

