/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.ServiceException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.gc.GarbageCollectable;
import org.exolab.jms.gc.GarbageCollectionService;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DestinationCacheEventListener;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.DurableConsumerEndpoint;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.QueueBrowserEndpoint;
import org.exolab.jms.messagemgr.QueueConsumerEndpoint;
import org.exolab.jms.messagemgr.TopicConsumerEndpoint;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.JmsServerSession;

public class ConsumerManager
implements DestinationCacheEventListener,
GarbageCollectable {
    private HashMap _endpoints = new HashMap();
    private HashMap _consumerCache = new HashMap();
    private HashMap _destToConsumerMap = new HashMap();
    private HashMap _wildcardConsumers = new HashMap();
    private Scheduler _scheduler = null;
    private static ConsumerManager _instance = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$ConsumerManager == null ? (class$org$exolab$jms$messagemgr$ConsumerManager = ConsumerManager.class$("org.exolab.jms.messagemgr.ConsumerManager")) : class$org$exolab$jms$messagemgr$ConsumerManager));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$ConsumerManager;

    public static ConsumerManager createInstance() throws ServiceException {
        _instance = new ConsumerManager();
        return _instance;
    }

    public static ConsumerManager instance() {
        return _instance;
    }

    private ConsumerManager() throws ServiceException {
        GarbageCollectionService.instance().register(this);
        this.init();
    }

    public synchronized void createDurableConsumer(JmsTopic topic, String name) throws JMSException {
        PersistenceAdapter adapter = DatabaseService.getAdapter();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                if (!adapter.checkDestination(connection, topic.getName())) {
                    throw new JMSException("Cannot create durable consumer, name=" + name + ", for non-administered topic=" + topic.getName());
                }
                if (!adapter.durableConsumerExists(connection, name)) {
                    adapter.addDurableConsumer(connection, topic.getName(), name);
                }
                connection.commit();
                this.addToConsumerCache(name, topic, true);
            }
            catch (JMSException exception) {
                throw exception;
            }
            catch (Exception exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to create durable consumer, name=" + name + ", for topic=" + topic.getName();
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg + ": " + exception.getMessage());
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public synchronized void removeDurableConsumer(String name) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeDurableConsumer(name=" + name + ")"));
        }
        if (!this.durableConsumerExists(name)) {
            throw new JMSException("Durable consumer " + name + " is not defined.");
        }
        if (this.isDurableConsumerActive(name)) {
            throw new JMSException("Cannot remove durable consumer=" + name + ": consumer is active");
        }
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                DatabaseService.getAdapter().removeDurableConsumer(connection, name);
                ConsumerEndpoint endpoint = this.getConsumerEndpoint(name);
                if (endpoint != null) {
                    this.deleteConsumerEndpoint(endpoint);
                }
                this.removeFromConsumerCache(name);
                connection.commit();
            }
            catch (Exception exception) {
                SQLHelper.rollback(connection);
                String msg = "Failed to remove durable consumer, name=" + name;
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg + ":" + exception.getMessage());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public synchronized void removeDurableConsumers(JmsDestination topic) throws JMSException {
        Vector consumers = (Vector)this._destToConsumerMap.get(topic);
        if (consumers != null) {
            Enumeration entries = consumers.elements();
            while (entries.hasMoreElements()) {
                ConsumerEntry entry = (ConsumerEntry)entries.nextElement();
                if (!entry._durable) continue;
                this.removeDurableConsumer(entry._name);
            }
        }
        this.removeFromConsumerCache(topic);
    }

    public synchronized ConsumerEndpoint createConsumerEndpoint(JmsServerSession session, long clientId, JmsDestination destination, String selector) throws JMSException, InvalidSelectorException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createConsumerEndpoint(session=[sessionId=" + session.getSessionId() + "], clientId=" + clientId + ", destination=" + destination + ", selector=" + selector + ")"));
        }
        ConsumerEndpoint endpoint = null;
        DestinationManager destmgr = DestinationManager.instance();
        if (destination.getPersistent()) {
            if (!destmgr.destinationExists(destination)) {
                throw new JMSException("Cannot create consumer endpoint: destination=" + destination + " does not exist");
            }
        } else if (!destmgr.destinationExists(destination)) {
            destmgr.createDestination(destination);
        }
        if (destination instanceof JmsTopic) {
            JmsTopic topic = (JmsTopic)destination;
            endpoint = new TopicConsumerEndpoint(session, clientId, topic, selector, this._scheduler);
        } else if (destination instanceof JmsQueue) {
            this.cleanUnreferencedEndpoints(destination);
            endpoint = new QueueConsumerEndpoint(session, clientId, (JmsQueue)destination, selector, this._scheduler);
        }
        if (endpoint != null) {
            String id = endpoint.getPersistentId();
            this._endpoints.put(id, endpoint);
            this.addToConsumerCache(id, destination, false);
        }
        return endpoint;
    }

    public synchronized DurableConsumerEndpoint createDurableConsumerEndpoint(JmsServerSession session, JmsTopic topic, String name, long clientId, String selector) throws JMSException {
        DurableConsumerEndpoint endpoint;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createDurableConsumerEndpoint(session=[sessionId=" + session.getSessionId() + "], topic=" + topic + ", name=" + name + ", clientId=" + clientId + ", selector=" + selector));
        }
        if ((endpoint = (DurableConsumerEndpoint)this._endpoints.get(name)) != null) {
            if (endpoint.getSession().isClientEndpointActive()) {
                throw new JMSException(name + " is already registered");
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Closing session for inactive durable consumer [name=" + name + "]"));
            }
            endpoint.getSession().close();
        }
        if (!topic.isWildCard() && !DestinationManager.instance().destinationExists(topic)) {
            throw new JMSException("Cannot create a durable consumer for " + topic);
        }
        endpoint = new DurableConsumerEndpoint(session, clientId, topic, name, selector, this._scheduler);
        this._endpoints.put(endpoint.getPersistentId(), endpoint);
        return endpoint;
    }

    public synchronized boolean hasActiveDurableConsumers(JmsDestination topic) {
        boolean result = false;
        Vector consumers = (Vector)this._destToConsumerMap.get(topic);
        if (consumers != null) {
            Enumeration iterator = consumers.elements();
            while (iterator.hasMoreElements()) {
                ConsumerEntry entry = (ConsumerEntry)iterator.nextElement();
                if (!entry._durable) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public synchronized ConsumerEndpoint createQueueBrowserEndpoint(JmsServerSession session, long clientId, JmsQueue queue, String selector) throws JMSException {
        QueueBrowserEndpoint consumer = null;
        if (queue == null) {
            throw new JMSException("Cannot create a browser for a null queue");
        }
        consumer = new QueueBrowserEndpoint(session, clientId, queue, selector, this._scheduler);
        String id = consumer.getPersistentId();
        this._endpoints.put(id, consumer);
        this.addToConsumerCache(id, queue, false);
        return consumer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void deleteDurableConsumerEndpoint(String name) throws JMSException {
        ConsumerEntry entry;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("deleteDurableConsumerEndpoint(name=" + name + ")"));
        }
        if ((entry = (ConsumerEntry)this._consumerCache.get(name)) != null) {
            if (!entry._durable) throw new JMSException(name + " is not a durable subscriber");
            this.deleteConsumerEndpoint((ConsumerEndpoint)this._endpoints.get(name));
            return;
        } else {
            if (!_log.isDebugEnabled()) return;
            _log.debug((Object)("deleteDurableConsumerEndpoint(name=" + name + "): failed to locate consumer"));
        }
    }

    public synchronized void deleteConsumerEndpoint(ConsumerEndpoint consumer) {
        String id;
        ConsumerEndpoint existing;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("deleteConsumerEndpoint(consumer=[clientId=" + consumer.getClientId() + ", destination=" + consumer.getDestination() + ", session=[sessionId=" + consumer.getSession().getSessionId() + "]])"));
        }
        if ((existing = (ConsumerEndpoint)this._endpoints.get(id = consumer.getPersistentId())) != null) {
            consumer.unregister();
            if (consumer.getId().equals(existing.getId())) {
                this._endpoints.remove(id);
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)"Existing endpoint doesn't match that to be deleted - retaining");
            }
            consumer.close();
            if (!(consumer instanceof DurableConsumerEndpoint)) {
                try {
                    this.removeFromConsumerCache(id);
                }
                catch (JMSException exception) {
                    _log.debug((Object)("Failed to remove " + id + " from the cache"), (Throwable)exception);
                }
            }
        }
    }

    public ConsumerEndpoint getConsumerEndpoint(String id) {
        return (ConsumerEndpoint)this._endpoints.get(id);
    }

    public Iterator consumerEndpoints() {
        return this._endpoints.values().iterator();
    }

    public Iterator consumerIds() {
        return this._endpoints.keySet().iterator();
    }

    public boolean exists(String id) {
        return this.getConsumerEndpoint(id) != null;
    }

    public boolean hasActiveConsumers(JmsDestination destination) throws JMSException {
        boolean result = false;
        Object[] endpoints = this._endpoints.values().toArray();
        int index = 0;
        while (index < endpoints.length) {
            ConsumerEndpoint endpoint = (ConsumerEndpoint)endpoints[index];
            JmsDestination endpoint_dest = endpoint.getDestination();
            if (destination instanceof JmsTopic && endpoint_dest instanceof JmsTopic && ((JmsTopic)endpoint_dest).isWildCard()) {
                if (((JmsTopic)endpoint_dest).match((JmsTopic)destination)) {
                    result = true;
                    break;
                }
            } else if (endpoint_dest.equals(destination)) {
                result = true;
                break;
            }
            ++index;
        }
        return result;
    }

    public boolean isDurableConsumerActive(String name) {
        return this._endpoints.get(name) != null;
    }

    public JmsDestination getDestinationForConsumerName(String name) {
        ConsumerEntry entry = (ConsumerEntry)this._consumerCache.get(name);
        return entry != null ? entry._destination : null;
    }

    public boolean durableConsumerExists(String name) {
        boolean result = false;
        ConsumerEntry entry = (ConsumerEntry)this._consumerCache.get(name);
        if (entry != null && entry._durable) {
            result = true;
        }
        return result;
    }

    public boolean validSubscription(String topic, String name) {
        boolean result = false;
        ConsumerEntry entry = (ConsumerEntry)this._consumerCache.get(name);
        if (entry != null && entry._destination != null && entry._destination.getName().equals(topic)) {
            result = true;
        }
        return result;
    }

    public synchronized boolean messageAdded(MessageImpl message) {
        return false;
    }

    public synchronized boolean messageRemoved(MessageImpl message) {
        return false;
    }

    public synchronized boolean persistentMessageAdded(Connection connection, MessageImpl message) throws PersistenceException {
        try {
            JmsDestination dest = (JmsDestination)message.getJMSDestination();
            if (dest instanceof JmsQueue) {
                return false;
            }
            Vector names = this.getDurableConsumersForDest((JmsTopic)dest);
            while (names.size() > 0) {
                String name = (String)names.remove(0);
                MessageHandleFactory.createPersistentHandle(connection, dest, name, message);
            }
        }
        catch (JMSException exception) {
            throw new PersistenceException("Failed to create persistent handle", exception);
        }
        return false;
    }

    public synchronized boolean persistentMessageRemoved(Connection connection, MessageImpl message) throws PersistenceException {
        try {
            JmsDestination dest = (JmsDestination)message.getJMSDestination();
            if (dest instanceof JmsQueue) {
                return false;
            }
            Vector consumers = (Vector)this._destToConsumerMap.get(dest);
            if (consumers != null) {
                Enumeration entries = consumers.elements();
                while (entries.hasMoreElements()) {
                    ConsumerEntry entry = (ConsumerEntry)entries.nextElement();
                    if (!entry._durable || this._endpoints.containsKey(entry._name)) continue;
                    MessageHandleFactory.destroyPersistentHandle(connection, dest, entry._name, message);
                }
            }
        }
        catch (PersistenceException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PersistenceException("Exception in ConsumerManager.persistentMessageRemoved " + exception.toString());
        }
        return true;
    }

    public synchronized void destroy() {
        Object[] endpoints = this._endpoints.values().toArray();
        int index = 0;
        while (index < endpoints.length) {
            this.deleteConsumerEndpoint((ConsumerEndpoint)endpoints[index]);
            ++index;
        }
        this._endpoints.clear();
        this._consumerCache.clear();
        this._consumerCache = null;
        this._destToConsumerMap.clear();
        this._destToConsumerMap = null;
        this._wildcardConsumers.clear();
        this._wildcardConsumers = null;
        _instance = null;
    }

    public synchronized Vector getDurableConsumersForDest(JmsTopic dest) {
        ConsumerEntry entry;
        Vector<String> names = new Vector<String>();
        Vector consumers = (Vector)this._destToConsumerMap.get(dest);
        if (consumers != null) {
            Enumeration entries = consumers.elements();
            while (entries.hasMoreElements()) {
                entry = (ConsumerEntry)entries.nextElement();
                if (!entry._durable) continue;
                names.add(entry._name);
            }
        }
        Iterator wildconsumers = this._wildcardConsumers.keySet().iterator();
        while (wildconsumers.hasNext()) {
            entry = (ConsumerEntry)wildconsumers.next();
            JmsDestination adest = entry._destination;
            if (!entry._durable || !(adest instanceof JmsTopic) || !((JmsTopic)adest).match(dest)) continue;
            names.add(entry._name);
        }
        return names;
    }

    public void cleanUnreferencedEndpoints(JmsDestination dest) {
        Object[] endpoints = this._endpoints.values().toArray();
        int index = 0;
        while (index < endpoints.length) {
            ConsumerEndpoint endpoint = (ConsumerEndpoint)endpoints[index];
            if (dest.equals(endpoint.getDestination()) && !endpoint.getSession().isClientEndpointActive()) {
                try {
                    endpoint.getSession().close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            ++index;
        }
    }

    public synchronized LinkedList getEndpointsForDest(JmsDestination dest) {
        LinkedList<ConsumerEndpoint> endpoints = new LinkedList<ConsumerEndpoint>();
        Iterator iter = this._endpoints.values().iterator();
        while (iter.hasNext()) {
            ConsumerEndpoint endpoint = (ConsumerEndpoint)iter.next();
            if (!dest.equals(endpoint.getDestination())) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public synchronized void collectGarbage(boolean aggressive) {
        if (aggressive) {
            Object[] endpoints = this._endpoints.values().toArray();
            int count = endpoints.length;
            int index = 0;
            while (index < count) {
                ((ConsumerEndpoint)endpoints[index]).collectGarbage(aggressive);
                ++index;
            }
        }
    }

    synchronized void addToConsumerCache(String name, JmsDestination dest, boolean durable) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("addToConsumerCache(name=" + name + ", dest=" + dest + ", durable=" + durable + ")"));
        }
        if (!this._consumerCache.containsKey(name)) {
            ConsumerEntry entry = new ConsumerEntry(name, dest, durable);
            this._consumerCache.put(name, entry);
            if (dest instanceof JmsTopic && ((JmsTopic)dest).isWildCard()) {
                this._wildcardConsumers.put(new ConsumerEntry(name, dest, durable), dest);
            } else {
                Vector<ConsumerEntry> consumers = (Vector<ConsumerEntry>)this._destToConsumerMap.get(dest);
                if (consumers == null) {
                    consumers = new Vector<ConsumerEntry>();
                    this._destToConsumerMap.put(dest, consumers);
                }
                consumers.add(entry);
            }
        }
    }

    synchronized void removeFromConsumerCache(String name) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeFromConsumerCache(name=" + name + ")"));
        }
        if (this._consumerCache.containsKey(name)) {
            ConsumerEntry entry = (ConsumerEntry)this._consumerCache.remove(name);
            JmsDestination dest = entry._destination;
            if (dest instanceof JmsTopic && ((JmsTopic)dest).isWildCard()) {
                this._wildcardConsumers.remove(name);
            } else {
                Vector consumers = (Vector)this._destToConsumerMap.get(dest);
                if (consumers != null) {
                    consumers.remove(entry);
                    if (consumers.size() == 0) {
                        this._destToConsumerMap.remove(dest);
                    }
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeFromConsumerCache(name=" + name + "): consumer not found"));
        }
    }

    synchronized void removeFromConsumerCache(JmsDestination destination) {
        if (this._destToConsumerMap.containsKey(destination)) {
            this._destToConsumerMap.remove(destination);
        }
    }

    int getConsumerEndpointCount() {
        return this._endpoints.size();
    }

    private void init() throws ServiceException {
        this._scheduler = Scheduler.instance();
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                PersistenceAdapter adapter = DatabaseService.getAdapter();
                connection.commit();
                HashMap map = adapter.getAllDurableConsumers(connection);
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    String consumer = (String)iter.next();
                    String deststr = (String)map.get(consumer);
                    JmsDestination dest = DestinationManager.instance().destinationFromString(deststr);
                    if (dest == null && !((JmsTopic)(dest = new JmsTopic(deststr))).isWildCard()) {
                        dest = null;
                    }
                    if (consumer != null && dest != null && dest instanceof JmsTopic) {
                        this.addToConsumerCache(consumer, dest, true);
                        continue;
                    }
                    _log.error((Object)("Failure in ConsumerManager.init : " + consumer + ":" + dest));
                }
            }
            catch (ServiceException exception) {
                SQLHelper.rollback(connection);
                throw exception;
            }
            catch (Exception exception) {
                SQLHelper.rollback(connection);
                throw new ServiceException("Failed to initialise ConsumerManager", (Throwable)exception);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConsumerEntry {
        String _name = null;
        boolean _durable = false;
        JmsDestination _destination = null;

        ConsumerEntry(String name, JmsDestination destination, boolean durable) {
            this._name = name;
            this._destination = destination;
            this._durable = durable;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof ConsumerEntry && ((ConsumerEntry)obj)._name.equals(this._name)) {
                result = true;
            }
            return result;
        }
    }
}

