/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.Identifiable;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageHandle;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.CacheEvictionPolicy;
import org.exolab.jms.messagemgr.DestinationCacheEventListener;
import org.exolab.jms.messagemgr.InternalMessageListener;
import org.exolab.jms.messagemgr.MessageCache;
import org.exolab.jms.messagemgr.MessageHandleFactory;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.selector.Selector;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.util.UUID;

public abstract class ConsumerEndpoint
implements Serializable,
Identifiable,
DestinationCacheEventListener,
Runnable {
    private String _id;
    private long _clientId = -1L;
    protected Selector _selector = null;
    protected final Object _waitingForMessageMonitor = new Object();
    protected boolean _waitingForMessage = false;
    protected InternalMessageListener _listener = null;
    protected int _size = 1000;
    protected transient Scheduler _scheduler = null;
    protected transient int _ackMode = 1;
    protected transient boolean _nolocal = false;
    protected transient boolean _transacted = false;
    protected transient int _connectionId = -1;
    protected JmsServerSession _session = null;
    private volatile boolean _stopped = true;
    private volatile boolean _closed = false;
    private boolean _scheduled = false;
    private MessageCache _cache = new MessageCache();
    private final Object _lock = new Object();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$ConsumerEndpoint == null ? (class$org$exolab$jms$messagemgr$ConsumerEndpoint = ConsumerEndpoint.class$("org.exolab.jms.messagemgr.ConsumerEndpoint")) : class$org$exolab$jms$messagemgr$ConsumerEndpoint));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$ConsumerEndpoint;

    ConsumerEndpoint(JmsServerSession session, long clientId, String selector, Scheduler scheduler) throws InvalidSelectorException {
        this._id = UUID.next();
        this._selector = selector != null ? new Selector(selector) : null;
        this._clientId = clientId;
        this._scheduler = scheduler;
        this._session = session;
    }

    public abstract JmsDestination getDestination();

    public String getId() {
        return this._id;
    }

    public String getPersistentId() {
        return this.getId();
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String toString() {
        return this._id + ":" + this.getDestination();
    }

    public abstract void unregister();

    public long getClientId() {
        return this._clientId;
    }

    public Selector getSelector() {
        return this._selector;
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        this._selector = selector != null ? new Selector(selector) : null;
    }

    public int getAckMode() {
        return this._ackMode;
    }

    public void setAckMode(int ackmode) {
        this._ackMode = ackmode;
    }

    public int getConnectionId() {
        return this._connectionId;
    }

    public void setConnectionId(int id) {
        this._connectionId = id;
    }

    public boolean getNoLocal() {
        return this._nolocal;
    }

    public void setNoLocal(boolean nolocal) {
        this._nolocal = nolocal;
    }

    public boolean getTransacted() {
        return this._transacted;
    }

    public void setTransacted(boolean transacted) {
        this._transacted = transacted;
    }

    public void setMaximumSize(int size) {
        this._size = size;
    }

    public int getMaximumSize() {
        return this._size;
    }

    public void setCacheEvictionPolicy(CacheEvictionPolicy policy) {
    }

    public int getMessageCount() {
        return this._cache.getHandleCount();
    }

    public JmsServerSession getSession() {
        return this._session;
    }

    public abstract boolean deliverMessages();

    public void run() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._closed) {
                boolean reschedule = this.deliverMessages();
                this._scheduled = false;
                if (reschedule) {
                    this.schedule();
                }
            }
        }
    }

    public synchronized boolean messageAdded(MessageImpl message) {
        boolean added = false;
        try {
            if (this.getNoLocal() && message.getConnectionId() == this.getConnectionId()) {
                return true;
            }
            MessageHandle handle = MessageHandleFactory.getHandle(this, message);
            if (!this._cache.containsHandle(handle)) {
                this.addMessage(handle, message);
                added = true;
                this.schedule();
            }
        }
        catch (JMSException exception) {
            _log.error((Object)"Failed to add message to endpoint", (Throwable)exception);
        }
        return added;
    }

    public synchronized boolean messageRemoved(MessageImpl message) {
        boolean removed = false;
        try {
            MessageHandle handle = MessageHandleFactory.getHandle(this, message);
            if (this._cache.containsHandle(handle)) {
                this.removeMessage(handle);
                removed = true;
            }
        }
        catch (JMSException exception) {
            _log.error((Object)"Failed to remove message from endpoint", (Throwable)exception);
        }
        return removed;
    }

    public synchronized boolean persistentMessageAdded(Connection connection, MessageImpl message) throws PersistenceException {
        return this.messageAdded(message);
    }

    public synchronized boolean persistentMessageRemoved(Connection connection, MessageImpl message) throws PersistenceException {
        return this.messageRemoved(message);
    }

    public synchronized void setStopped(boolean stop) {
        if (stop) {
            this._stopped = true;
        } else {
            this._stopped = false;
            this.schedule();
        }
    }

    public synchronized void recover() {
    }

    public final void close() {
        this._stopped = true;
        Object object = this._lock;
        synchronized (object) {
            this._scheduler.remove(this);
            this._scheduled = false;
        }
        ConsumerEndpoint consumerEndpoint = this;
        synchronized (consumerEndpoint) {
            this.doClose();
            if (this._cache != null) {
                this._cache.clear();
            }
            this._closed = true;
        }
    }

    public synchronized void setMessageListener(InternalMessageListener listener) {
        this._listener = listener;
        if (listener == null) {
            this._scheduler.remove(this);
            this._scheduled = false;
        } else {
            this.schedule();
        }
    }

    public synchronized void returnMessage(MessageHandle handle) {
        if (this._cache != null) {
            this.addMessage(handle);
            this.schedule();
        }
    }

    public abstract MessageHandle receiveMessage(long var1);

    public void collectGarbage(boolean aggressive) {
        if (aggressive) {
            this._cache.clearPersistentMessages();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Evicted all persistent messages from dest " + this.getDestination().getName() + " and name " + this.getId()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("ENDPOINT- " + this.getDestination().getName() + ":" + this.getPersistentId() + " Messages: P[" + this._cache.getPersistentCount() + "] T[" + this._cache.getTransientCount() + "] Handles: [" + this._cache.getHandleCount() + "]"));
        }
    }

    protected abstract void doClose();

    protected void schedule() {
        if (!(this._stopped || this._closed || this._listener == null || this._scheduled)) {
            this._scheduled = true;
            this._scheduler.add(this);
        }
    }

    protected void clearMessages() {
        this._cache.clear();
    }

    protected boolean collectionHasPersistentHandles(Vector collection) {
        boolean result = false;
        Enumeration enumeration = collection.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof PersistentMessageHandle)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void addMessage(MessageHandle handle) {
        handle.setConsumerName(this.getPersistentId());
        this._cache.addHandle(handle);
        if (this.isWaitingForMessage()) {
            this.notifyMessageAvailable();
        }
    }

    protected void addMessage(MessageHandle handle, MessageImpl message) {
        handle.setConsumerName(this.getPersistentId());
        this._cache.addMessage(handle, message);
        if (this.isWaitingForMessage()) {
            this.notifyMessageAvailable();
        }
    }

    protected MessageImpl getMessage(MessageHandle handle) {
        return this._cache.getMessage(handle);
    }

    protected boolean removeMessage(MessageHandle handle) {
        return this._cache.removeHandle(handle);
    }

    protected boolean containsMessage(MessageHandle handle) {
        return this._cache.containsHandle(handle);
    }

    protected MessageHandle removeFirstMessage() {
        return this._cache.removeFirstHandle();
    }

    protected void deleteMessage(MessageHandle handle) {
        this._cache.removeMessage(handle.getMessageId());
    }

    protected final boolean isStopped() {
        return this._stopped;
    }

    protected void notifyMessageAvailable() {
        if (this.isWaitingForMessage()) {
            this.clearWaitingForMessage();
            try {
                this._session.onMessageAvailable(this.getClientId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final boolean isWaitingForMessage() {
        return this._waitingForMessage;
    }

    protected final void setWaitingForMessage() {
        this._waitingForMessage = true;
    }

    protected final void clearWaitingForMessage() {
        this._waitingForMessage = false;
    }

    protected boolean stopDelivery() {
        return this._stopped || this.getMessageCount() == 0 || this._listener == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

