/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.lease;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.core.util.OrderedQueue;
import org.exolab.jms.lease.BaseLease;
import org.exolab.jms.lease.LeaseComparator;
import org.exolab.jms.lease.LeaseEventListenerIfc;
import org.exolab.jms.lease.MessageLease;
import org.exolab.jms.message.MessageHandle;

public class LeaseManager
extends BasicService {
    private static final String LEASE_MANAGER_THREAD_NAME = "LeaseManagerReaper";
    private OrderedQueue _queue = null;
    private static LeaseManager _instance = new LeaseManager();
    private final Object _waiter = new Object();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$lease$LeaseManager == null ? (class$org$exolab$jms$lease$LeaseManager = LeaseManager.class$("org.exolab.jms.lease.LeaseManager")) : class$org$exolab$jms$lease$LeaseManager));
    static /* synthetic */ Class class$org$exolab$jms$lease$LeaseManager;

    protected LeaseManager() {
        super(LEASE_MANAGER_THREAD_NAME);
        this._queue = new OrderedQueue((Comparator)new LeaseComparator());
    }

    public static LeaseManager instance() {
        return _instance;
    }

    public MessageLease createMessageLease(MessageHandle handle, long duration, LeaseEventListenerIfc listener) {
        MessageLease result = null;
        if (handle != null && duration > 0L) {
            result = new MessageLease(handle, duration, listener);
            this.addLease(result);
        }
        return result;
    }

    public BaseLease createLease(Object object, long duration, LeaseEventListenerIfc listener) {
        BaseLease result = null;
        if (object != null && duration > 0L) {
            result = new BaseLease(object, duration, listener);
            this.addLease(result);
        }
        return result;
    }

    public boolean removeLease(BaseLease lease) {
        boolean result = false;
        OrderedQueue orderedQueue = this._queue;
        synchronized (orderedQueue) {
            result = this._queue.remove((Object)lease);
        }
        if (result) {
            Object object = this._waiter;
            synchronized (object) {
                this._waiter.notify();
            }
        }
        return result;
    }

    public BaseLease renewLease(BaseLease lease, long duration) {
        BaseLease newlease = null;
        if (lease != null && duration > 0L) {
            OrderedQueue orderedQueue = this._queue;
            synchronized (orderedQueue) {
                if (this._queue.remove((Object)lease)) {
                    lease.setDuration(duration);
                    this._queue.add((Object)lease);
                    newlease = lease;
                    Object object = this._waiter;
                    synchronized (object) {
                        this._waiter.notify();
                    }
                }
            }
        }
        return newlease;
    }

    public void removeAll() {
        OrderedQueue orderedQueue = this._queue;
        synchronized (orderedQueue) {
            this._queue.clear();
        }
    }

    public int getLeaseCount() {
        return this._queue.size();
    }

    public void run() {
        while (this.getState() != ServiceState.STOPPED) {
            this.expire();
            Object object = this._waiter;
            synchronized (object) {
                try {
                    this._waiter.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stop() throws ServiceException {
        super.stop();
        Object object = this._waiter;
        synchronized (object) {
            this._waiter.notifyAll();
        }
    }

    protected void expire() {
        while (this._queue.size() > 0) {
            BaseLease lease = null;
            boolean expired = false;
            OrderedQueue orderedQueue = this._queue;
            synchronized (orderedQueue) {
                lease = (BaseLease)this._queue.firstElement();
                if (lease == null) {
                    continue;
                }
                if (lease.getExpiryTime() <= System.currentTimeMillis()) {
                    this._queue.removeFirstElement();
                    expired = true;
                }
            }
            if (expired) {
                lease.notifyLeaseExpired();
                continue;
            }
            long time = lease.getExpiryTime() - System.currentTimeMillis();
            if (time <= 0L) continue;
            try {
                Object object = this._waiter;
                synchronized (object) {
                    this._waiter.wait(time);
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
    }

    protected void addLease(BaseLease lease) {
        OrderedQueue orderedQueue = this._queue;
        synchronized (orderedQueue) {
            this._queue.add((Object)lease);
            if (this._queue.firstElement() == lease) {
                Object object = this._waiter;
                synchronized (object) {
                    this._waiter.notify();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

