/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.lease;

import java.io.Serializable;
import org.exolab.jms.lease.LeaseEventListenerIfc;
import org.exolab.jms.lease.LeaseIfc;

public class BaseLease
implements LeaseIfc,
Comparable,
Serializable {
    protected Object leasedObject_ = null;
    protected long duration_ = 0L;
    protected long expiryTime_ = 0L;
    protected LeaseEventListenerIfc listener_ = null;

    public BaseLease() {
    }

    public BaseLease(Object object, long duration, LeaseEventListenerIfc listener) {
        if (object == null || listener == null) {
            throw new IllegalArgumentException("object or listener cannot be null");
        }
        this.leasedObject_ = object;
        this.duration_ = duration;
        this.expiryTime_ = System.currentTimeMillis() + duration;
        this.listener_ = listener;
    }

    public long getExpiryTime() {
        return this.expiryTime_;
    }

    public long getDuration() {
        return this.duration_;
    }

    public void setDuration(long duration) {
        this.duration_ = duration;
        this.expiryTime_ = System.currentTimeMillis() + duration;
    }

    public long getRemainingTime() {
        return System.currentTimeMillis() - this.expiryTime_;
    }

    public Object getLeasedObject() {
        return this.leasedObject_;
    }

    public Class getLeasedObjectType() {
        return this.leasedObject_.getClass();
    }

    public LeaseEventListenerIfc getLeaseEventListener() {
        return this.listener_;
    }

    public int compareTo(Object object) {
        BaseLease lease;
        int result = 0;
        if (object instanceof BaseLease && (lease = (BaseLease)object).getExpiryTime() != this.getExpiryTime()) {
            result = lease.getExpiryTime() > this.getExpiryTime() ? -1 : 1;
        }
        return result;
    }

    void notifyLeaseExpired() {
        LeaseEventListenerIfc leaseEventListenerIfc = this.listener_;
        synchronized (leaseEventListenerIfc) {
            this.listener_.onLeaseExpired(this.leasedObject_);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.leasedObject_.toString());
        buf.append(" duration = ");
        buf.append(this.duration_);
        buf.append(" expiryTime = ");
        buf.append(this.expiryTime_);
        return buf.toString();
    }
}

