/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndiadministration;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exolab.jms.jndiadministration.AdminConnection;
import org.exolab.jms.jndiadministration.ObjectDialog;
import org.exolab.jms.jndiadministration.OpenJMSContext;

public class OpenJMSServer
extends DefaultMutableTreeNode {
    private String serverName_;
    private static JTree tree_ = null;
    private static boolean commandsCreated_ = false;
    private static JPopupMenu commands_ = null;

    public OpenJMSServer(String serverName, JTree tree) {
        this.serverName_ = serverName;
        if (!commandsCreated_) {
            tree_ = tree;
            this.createCommands();
            commandsCreated_ = true;
        }
    }

    protected void createCommands() {
        commands_ = new JPopupMenu();
        JMenuItem m = new JMenuItem("Create Context");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSServer.createContext();
            }
        });
        commands_.add(m);
    }

    public static DefaultTreeModel createServerList(JTree tree) {
        OpenJMSServer server = new OpenJMSServer("Root", tree);
        return new DefaultTreeModel(server);
    }

    public void displayContexts() {
        Enumeration e = AdminConnection.instance().getAllContexts(null);
        if (e != null) {
            while (e.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)e.nextElement();
                this.add(new OpenJMSContext(pair.getName(), null, tree_));
            }
            this.refresh();
        }
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public void displayCommands(Rectangle loc) {
        double x = loc.getX();
        double y = loc.getY();
        commands_.show(tree_, (int)x, (int)(y += loc.getHeight()));
    }

    public String toString() {
        return this.serverName_;
    }

    public void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)tree_.getModel();
        model.nodeStructureChanged(this);
    }

    private static OpenJMSServer getInstanceSelected() {
        Object loc = tree_.getLastSelectedPathComponent();
        return (OpenJMSServer)loc;
    }

    private static void createContext() {
        OpenJMSServer This = OpenJMSServer.getInstanceSelected();
        ObjectDialog.instance().display("Enter a unique context name", "Context Creation");
        if (ObjectDialog.instance().isConfirmed()) {
            try {
                AdminConnection.instance().createContext(ObjectDialog.instance().getName());
                This.add(new OpenJMSContext(ObjectDialog.instance().getName(), null, tree_));
                This.refresh();
            }
            catch (NamingException err) {
                JOptionPane.showMessageDialog(tree_, err.getMessage(), "Context Create Error", 0);
            }
        }
    }
}

