/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndiadministration;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.jndiadministration.AdminConnection;
import org.exolab.jms.jndiadministration.ObjectDialog;
import org.exolab.jms.jndiadministration.OpenJMSNode;
import org.exolab.jms.jndiadministration.OpenJMSObject;
import org.exolab.jms.jndiadministration.QueryDialog;

public class OpenJMSContext
extends DefaultMutableTreeNode
implements OpenJMSNode {
    private String contextName_;
    private String displayName_;
    private boolean isLeaf_;
    private boolean isExplored_ = false;
    private static JTree tree_ = null;
    private static boolean commandsCreated_ = false;
    private static JPopupMenu commands_ = null;

    public OpenJMSContext(String contextName, String parentName, JTree tree) {
        this.contextName_ = parentName != null ? parentName + "." + contextName : contextName;
        this.displayName_ = contextName;
        this.isLeaf_ = false;
        if (!commandsCreated_) {
            tree_ = tree;
            this.createCommands();
            commandsCreated_ = true;
        }
    }

    protected void createCommands() {
        commands_ = new JPopupMenu();
        JMenuItem m = new JMenuItem("Add Context");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSContext.createContext();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Bind Object");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSContext.bindObject();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Rename Context");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSContext.renameContext();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Delete Context");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSContext.deleteContext();
            }
        });
        commands_.add(m);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.isLeaf_;
    }

    public void update() {
        if (!this.isExplored_) {
            Object ob = AdminConnection.instance().lookup(this.contextName_);
            if (ob != null) {
                if (ob instanceof Context) {
                    Enumeration e = AdminConnection.instance().getAllContexts(this.contextName_);
                    if (e != null) {
                        while (e.hasMoreElements()) {
                            NameClassPair pair = (NameClassPair)e.nextElement();
                            this.add(new OpenJMSContext(pair.getName(), this.contextName_, tree_));
                        }
                    }
                } else {
                    this.add(new OpenJMSObject(ob.getClass().getName(), tree_));
                }
                this.refresh();
            }
            this.isExplored_ = true;
        }
    }

    public void displayCommands(Rectangle loc) {
        double x = loc.getX();
        double y = loc.getY();
        commands_.show(tree_, (int)x, (int)(y += loc.getHeight()));
    }

    public String toString() {
        return this.displayName_;
    }

    private void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)tree_.getModel();
        model.nodeStructureChanged(this);
    }

    private static OpenJMSContext getInstanceSelected() {
        Object loc = tree_.getLastSelectedPathComponent();
        return (OpenJMSContext)loc;
    }

    private static void createContext() {
        OpenJMSContext This = OpenJMSContext.getInstanceSelected();
        ObjectDialog.instance().display("Enter a unique context name", "Context Creation");
        if (ObjectDialog.instance().isConfirmed()) {
            try {
                AdminConnection.instance().createContext(This.contextName_ + "." + ObjectDialog.instance().getName());
                This.add(new OpenJMSContext(ObjectDialog.instance().getName(), This.contextName_, tree_));
                This.refresh();
            }
            catch (NamingException exception) {
                JOptionPane.showMessageDialog(tree_, exception.getMessage(), "Context Create Error", 0);
            }
        }
    }

    private static void renameContext() {
        OpenJMSContext This = OpenJMSContext.getInstanceSelected();
        ObjectDialog.instance().display("Enter a new context name\nfor context: " + This.displayName_, "Rename Context");
        if (ObjectDialog.instance().isConfirmed()) {
            try {
                String newName = This.contextName_.substring(0, This.contextName_.indexOf(This.displayName_));
                newName = newName + ObjectDialog.instance().getName();
                AdminConnection.instance().renameContext(This.contextName_, newName);
                This.contextName_ = newName;
                This.displayName_ = ObjectDialog.instance().getName();
                This.refresh();
            }
            catch (NamingException exception) {
                JOptionPane.showMessageDialog(tree_, exception.getMessage(), "Context Rename Error", 0);
            }
        }
    }

    private static void bindObject() {
        String errorString = null;
        OpenJMSContext This = OpenJMSContext.getInstanceSelected();
        ObjectDialog.instance().display("Enter the objects fully qualified name", "Bind Object");
        if (ObjectDialog.instance().isConfirmed()) {
            try {
                JmsDestination ob = null;
                if (ObjectDialog.instance().getName().equals("org.exolab.jms.client.JmsTopic")) {
                    ob = new JmsTopic(This.contextName_);
                } else if (ObjectDialog.instance().getName().equals("org.exolab.jms.client.JmsQueue")) {
                    ob = new JmsQueue(This.contextName_);
                    ((JmsDestination)ob).setPersistent(true);
                } else {
                    ob = Class.forName(ObjectDialog.instance().getName()).newInstance();
                }
                AdminConnection.instance().rebind(This.contextName_, ob);
                This.removeAllChildren();
                This.add(new OpenJMSObject(ObjectDialog.instance().getName(), tree_));
                This.refresh();
            }
            catch (NamingException exception) {
                errorString = exception.getMessage();
            }
            catch (IllegalAccessException exception) {
                errorString = "Illegal Access error for\nObject: " + ObjectDialog.instance().getName();
            }
            catch (InstantiationException exception) {
                errorString = "Object: " + ObjectDialog.instance().getName() + "\nCannot be instantaiated";
            }
            catch (ClassNotFoundException exception) {
                errorString = "Object: " + ObjectDialog.instance().getName() + "\nCannot be found";
            }
            if (errorString != null) {
                JOptionPane.showMessageDialog(tree_, errorString, "Object bind error", 0);
            }
        }
    }

    private static void deleteContext() {
        OpenJMSContext This = OpenJMSContext.getInstanceSelected();
        QueryDialog.instance().display("Are you sure you want to delete \nselected Context: " + This.displayName_);
        if (QueryDialog.instance().isConfirmed()) {
            try {
                AdminConnection.instance().destroyContext(This.contextName_);
                This.removeFromParent();
                This.refresh();
            }
            catch (NamingException exception) {
                JOptionPane.showMessageDialog(tree_, exception.getMessage(), "Context Destroy Error", 0);
            }
        }
    }
}

