/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndiadministration;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JOptionPane;
import org.exolab.jms.jndiadministration.AdminConnection;
import org.exolab.jms.jndiadministration.OnlineConnectionException;

public class OnlineConnection
extends AdminConnection {
    private Context context_;
    private Component parent_;

    public OnlineConnection(Component parent) throws OnlineConnectionException {
        block4: {
            this.context_ = null;
            try {
                if (AdminConnection.instance_ == null) {
                    this.parent_ = parent;
                    AdminConnection.instance_ = this;
                    if (this.context_ == null) {
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("java.naming.factory.initial", "org.exolab.jms.jndi.rmi.RmiJndiInitialContextFactory");
                        this.context_ = new InitialContext(props);
                    }
                    break block4;
                }
                throw new OnlineConnectionException("Already connected");
            }
            catch (Exception err) {
                throw new OnlineConnectionException("Failed to connect: " + err);
            }
        }
    }

    private void displayError(Exception err, String st) {
        JOptionPane.showMessageDialog(this.parent_, st + "\n" + err, st, 0);
    }

    public void close() {
        try {
            this.context_.close();
            AdminConnection.instance_ = null;
            this.context_ = null;
        }
        catch (NamingException err) {
            this.displayError(err, "Failed to close context");
        }
    }

    public Enumeration getAllContexts(String name) {
        try {
            if (name == null) {
                name = "";
            }
            return this.context_.list(name);
        }
        catch (Exception err) {
            System.err.println("Err in getAllContexts\n" + err);
            return null;
        }
    }

    public Object lookup(String context) {
        try {
            return this.context_.lookup(context);
        }
        catch (Exception err) {
            System.err.println("Failed to get Context " + context + "\n" + err);
            return null;
        }
    }

    public void createContext(String name) throws NamingException {
        this.context_.createSubcontext(name);
    }

    public void destroyContext(String name) throws NamingException {
        this.context_.destroySubcontext(name);
    }

    public void renameContext(String oldName, String newName) throws NamingException {
        this.context_.rename(oldName, newName);
    }

    public void rebind(String name, Object ob) throws NamingException {
        this.context_.rebind(name, ob);
    }
}

