/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndiadministration;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.jndiadministration.AdminConnection;
import org.exolab.jms.jndiadministration.DatabaseFilter;
import org.exolab.jms.jndiadministration.OfflineConnectionException;
import org.exolab.jms.persistence.DatabaseService;

public class OfflineConnection
extends AdminConnection {
    private Component parent_;
    private Context context_;

    public OfflineConnection(Component parent) throws OfflineConnectionException {
        block7: {
            this.context_ = null;
            try {
                if (AdminConnection.instance_ == null) {
                    Configuration config = ConfigurationManager.getConfig();
                    this.parent_ = parent;
                    DatabaseConfiguration dbconfig = config.getDatabaseConfiguration();
                    if (dbconfig.getRdbmsDatabaseConfiguration() != null) {
                        DatabaseService.getAdapter();
                        AdminConnection.instance_ = this;
                    } else {
                        JFileChooser chooser = new JFileChooser(".");
                        chooser.setDialogTitle("Select OpenJMS Database to connect to");
                        chooser.setFileFilter(new DatabaseFilter());
                        int returnVal = chooser.showOpenDialog(parent);
                        if (returnVal == 0) {
                            DatabaseService.getAdapter();
                            AdminConnection.instance_ = this;
                        }
                    }
                    if (AdminConnection.instance_ != null && this.context_ == null) {
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("java.naming.factory.initial", "org.exolab.jms.jndi.intravm.IntravmJndiServer");
                        this.context_ = new InitialContext(props);
                    }
                    break block7;
                }
                throw new OfflineConnectionException("Already connected");
            }
            catch (Exception err) {
                throw new OfflineConnectionException("Database Error: " + err.getMessage());
            }
        }
    }

    public void close() {
        try {
            this.context_.close();
            DatabaseService.getAdapter().close();
            AdminConnection.instance_ = null;
            this.context_ = null;
        }
        catch (NamingException err) {
            this.displayError(err, "Failed to close context");
        }
    }

    public Enumeration getAllContexts(String name) {
        try {
            if (name == null) {
                name = "";
            }
            return this.context_.list(name);
        }
        catch (Exception err) {
            System.err.println("Err in getAllContexts\n" + err);
            return null;
        }
    }

    public Object lookup(String context) {
        try {
            return this.context_.lookup(context);
        }
        catch (Exception err) {
            System.err.println("Failed to get Context " + context + "\n" + err);
            return null;
        }
    }

    public void createContext(String name) throws NamingException {
        this.context_.createSubcontext(name);
    }

    public void destroyContext(String name) throws NamingException {
        this.context_.unbind(name);
    }

    public void renameContext(String oldName, String newName) throws NamingException {
        this.context_.rename(oldName, newName);
    }

    public void rebind(String name, Object ob) throws NamingException {
        this.context_.rebind(name, ob);
    }

    private void displayError(Exception err, String st) {
        JOptionPane.showMessageDialog(this.parent_, st + "\n" + err, st, 0);
    }
}

