/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndiadministration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.jndiadministration.AdminConnection;
import org.exolab.jms.jndiadministration.ObjectDialog;
import org.exolab.jms.jndiadministration.OfflineConnection;
import org.exolab.jms.jndiadministration.OnlineConnection;
import org.exolab.jms.jndiadministration.OpenJMSNode;
import org.exolab.jms.jndiadministration.OpenJMSServer;
import org.exolab.jms.jndiadministration.QueryDialog;
import org.exolab.jms.util.CommandLine;

public class AdminMgr
extends JFrame {
    private JMenuBar menuBar_;
    private JMenu file_;
    private JMenuItem exit_;
    private JMenu actions_;
    private JMenu connections_;
    private JMenuItem refresh_;
    private JMenuItem online_;
    private JMenuItem offline_;
    private JMenuItem disconnect_;
    private JScrollPane jMSServers_;
    private JTree serverProperties_;
    private JTextField messageArea_;
    private JComboBox jMSCombo_;
    private boolean connected_ = false;

    public AdminMgr() {
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.menuBar_ = new JMenuBar();
        this.file_ = new JMenu();
        this.exit_ = new JMenuItem();
        this.actions_ = new JMenu();
        this.connections_ = new JMenu();
        this.refresh_ = new JMenuItem();
        this.online_ = new JMenuItem();
        this.offline_ = new JMenuItem();
        this.disconnect_ = new JMenuItem();
        this.jMSServers_ = new JScrollPane();
        this.jMSCombo_ = new JComboBox();
        this.serverProperties_ = new JTree();
        this.setTitle("OpenJMS JNDI Admin");
        DefaultTreeModel serverModel = OpenJMSServer.createServerList(this.serverProperties_);
        this.serverProperties_.setModel(serverModel);
        this.messageArea_ = new JTextField();
        this.file_.setText("File");
        this.exit_.setToolTipText("Exit administration");
        this.exit_.setText("Exit");
        this.exit_.setMnemonic('x');
        this.serverProperties_.setRootVisible(false);
        this.serverProperties_.setShowsRootHandles(true);
        this.serverProperties_.putClientProperty("JTree.lineStyle", "Angled");
        this.serverProperties_.setEditable(false);
        this.setupCallbacks();
        this.file_.add(this.exit_);
        this.file_.setMnemonic('F');
        this.menuBar_.add(this.file_);
        this.actions_.setText("Actions");
        this.actions_.setMnemonic('A');
        this.connections_.setText("Connections");
        this.connections_.setMnemonic('C');
        this.refresh_.setToolTipText("Refresh the display");
        this.online_.setToolTipText("Connect to a running OpenJMS JNDI Server");
        this.offline_.setToolTipText("Connect directly to a JNDI database");
        this.refresh_.setText("Refresh");
        this.refresh_.setMnemonic('R');
        this.actions_.add(this.refresh_);
        this.online_.setText("Online");
        this.online_.setMnemonic('O');
        this.offline_.setText("Offline");
        this.offline_.setMnemonic('f');
        this.connections_.add(this.online_);
        this.connections_.add(this.offline_);
        this.actions_.add(this.connections_);
        this.disconnect_.setToolTipText("Disconnect from any connected OpenJMS JNDI Servers");
        this.disconnect_.setText("Disconnect");
        this.disconnect_.setMnemonic('D');
        this.actions_.add(this.disconnect_);
        this.menuBar_.add(this.actions_);
        this.jMSServers_.setViewportView(this.serverProperties_);
        this.getContentPane().add((Component)this.jMSServers_, "Center");
        this.messageArea_.setToolTipText("Message Area");
        this.messageArea_.setEditable(false);
        this.messageArea_.setForeground(Color.red);
        this.messageArea_.setText("Not Connected");
        this.messageArea_.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.messageArea_, "South");
        this.setJMenuBar(this.menuBar_);
        this.refresh_.setEnabled(false);
        this.disconnect_.setEnabled(false);
    }

    private void exitAdmin(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void refresh(ActionEvent evt) {
        if (AdminConnection.instance() instanceof OnlineConnection) {
            this.setConnected(false, null);
            this.setConnected(true, "Connected - Online Mode");
        } else {
            ((OpenJMSServer)this.serverProperties_.getModel().getRoot()).refresh();
        }
    }

    private void onlineConnect(ActionEvent evt) {
        try {
            new OnlineConnection(this);
            this.setConnected(true, "Connected - Online Mode");
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), "Online Connection Error", 0);
        }
    }

    private void offlineConnect(ActionEvent evt) {
        try {
            new OfflineConnection(this);
            this.setConnected(true, "Connected - OFFLine Mode");
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), "Database Error", 0);
        }
    }

    private void disconnect(ActionEvent evt) {
        try {
            AdminConnection.instance().close();
            this.setConnected(false, null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Database Close Error", 0);
        }
    }

    private void setConnected(boolean c, String st) {
        if (c) {
            this.serverProperties_.setRootVisible(true);
            ((OpenJMSServer)this.serverProperties_.getModel().getRoot()).displayContexts();
            this.connections_.setEnabled(false);
            this.refresh_.setEnabled(true);
            this.disconnect_.setEnabled(true);
            this.messageArea_.setForeground(Color.green.darker().darker());
            this.messageArea_.setText(st);
            this.connected_ = true;
        } else {
            this.serverProperties_.setRootVisible(false);
            OpenJMSServer root = (OpenJMSServer)this.serverProperties_.getModel().getRoot();
            root.removeAllChildren();
            DefaultTreeModel model = (DefaultTreeModel)this.serverProperties_.getModel();
            model.nodeStructureChanged(root);
            this.connections_.setEnabled(true);
            this.refresh_.setEnabled(false);
            this.disconnect_.setEnabled(false);
            this.messageArea_.setForeground(Color.red);
            this.messageArea_.setText("Not Connected");
            this.connected_ = false;
        }
    }

    private void setupCallbacks() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AdminMgr.this.exitForm(evt);
            }
        });
        this.serverProperties_.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!AdminMgr.this.connected_) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    int selRow = AdminMgr.this.serverProperties_.getRowForLocation(e.getX(), e.getY());
                    AdminMgr.this.serverProperties_.setSelectionRow(selRow);
                    Object loc = AdminMgr.this.serverProperties_.getLastSelectedPathComponent();
                    if (loc instanceof OpenJMSNode) {
                        OpenJMSNode node = (OpenJMSNode)loc;
                        node.displayCommands(AdminMgr.this.serverProperties_.getRowBounds(selRow));
                    } else if (loc instanceof OpenJMSServer) {
                        ((OpenJMSServer)loc).displayCommands(AdminMgr.this.serverProperties_.getRowBounds(selRow));
                    }
                }
            }
        });
        this.serverProperties_.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                Object loc = path.getLastPathComponent();
                if (loc instanceof OpenJMSNode) {
                    OpenJMSNode node = (OpenJMSNode)loc;
                    node.update();
                }
            }
        });
        this.exit_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.exitAdmin(evt);
            }
        });
        this.refresh_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.refresh(evt);
            }
        });
        this.online_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.onlineConnect(evt);
            }
        });
        this.offline_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.offlineConnect(evt);
            }
        });
        this.disconnect_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminMgr.this.disconnect(evt);
            }
        });
    }

    public static void main(String[] args) {
        try {
            CommandLine cmdline = new CommandLine(args);
            if (cmdline.exists("help")) {
                AdminMgr.usage();
            } else if (cmdline.exists("config")) {
                ConfigurationManager.setConfig(cmdline.value("config"));
                Configuration config = ConfigurationManager.getConfig();
                AdminMgr admin = new AdminMgr();
                QueryDialog.create(admin);
                ObjectDialog.create(admin);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)admin).setLocation(screen.width / 2 - 150, screen.height / 2 - 150);
                ((Component)admin).setSize(300, 300);
                admin.invalidate();
                admin.show();
            } else {
                AdminMgr.usage();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            System.err.println("Failed to initialize JNDI AdminMgr.\nExiting....");
        }
    }

    protected static void usage() {
        PrintStream out = System.out;
        out.println("\n\n");
        out.println("=====================================================");
        out.println("Usage information for org.exolab.jms.jndiadministration.AdminMgr");
        out.println("=====================================================");
        out.println("\norg.exolab.jms.jndiadministration.AdminMgr");
        out.println("    [-help | -config <xml config file>]\n");
        out.println("\t-help   displays this screen\n");
        out.println("\t-config file name of xml-based config file\n");
    }
}

