/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi.mipc;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import org.apache.avalon.excalibur.naming.DefaultNamespace;
import org.apache.avalon.excalibur.naming.RemoteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.ipc.Client;
import org.exolab.jms.jndi.mipc.NameServiceProxy;

public class IpcJndiInitialContextFactory
implements InitialContextFactory {
    private static final String TCP_SCHEME = "tcp://";
    private static final String TCPS_SCHEME = "tcps://";
    private static final String SCHEME_SEPARATOR = "://";
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final String URL_TERMINATOR = "/";
    private String _host;
    private int _port;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$jndi$mipc$IpcJndiInitialContextFactory == null ? (class$org$exolab$jms$jndi$mipc$IpcJndiInitialContextFactory = IpcJndiInitialContextFactory.class$("org.exolab.jms.jndi.mipc.IpcJndiInitialContextFactory")) : class$org$exolab$jms$jndi$mipc$IpcJndiInitialContextFactory));
    static /* synthetic */ Class class$org$exolab$jms$jndi$mipc$IpcJndiInitialContextFactory;

    public Context getInitialContext(Hashtable environment) throws NamingException {
        NameParser parser;
        Object context = null;
        String url = (String)environment.get("java.naming.provider.url");
        if (url == null || url.length() == 0) {
            url = this.getDeprecatedEnvironment(environment);
        }
        this.parseURL(url);
        Client connection = this.openConnection();
        NameServiceProxy provider = new NameServiceProxy(connection);
        try {
            parser = provider.getNameParser();
        }
        catch (NamingException exception) {
            throw exception;
        }
        catch (Exception exception) {
            ServiceUnavailableException error = new ServiceUnavailableException(exception.getMessage());
            error.setRootCause(exception);
            throw error;
        }
        DefaultNamespace namespace = new DefaultNamespace(parser);
        Hashtable<String, Object> env = new Hashtable<String, Object>(environment);
        env.put("org.apache.avalon.excalibur.naming.NamingProvider", provider);
        env.put("org.apache.avalon.excalibur.naming.Namespace", namespace);
        return new RemoteContext(env, parser.parse(""));
    }

    private void parseURL(String url) throws NamingException {
        if (url.startsWith("mipc://")) {
            _log.warn((Object)(this.getClass().getName() + ": using deprecated Context.PROVIDER_URL=" + url));
            url = TCP_SCHEME + url.substring(7);
        } else if (!url.startsWith(TCP_SCHEME) && !url.startsWith(TCPS_SCHEME)) {
            throw new ConfigurationException("URL=" + url + " has an invalid scheme");
        }
        int schemeIndex = url.indexOf(SCHEME_SEPARATOR);
        int hostIndex = url.indexOf(HOST_PORT_SEPARATOR, schemeIndex + SCHEME_SEPARATOR.length());
        if (hostIndex == -1) {
            throw new ConfigurationException("URL=" + url + " is invalid");
        }
        int endIndex = url.indexOf(URL_TERMINATOR, hostIndex + HOST_PORT_SEPARATOR.length());
        if (endIndex != -1 && endIndex != url.length() - 1) {
            throw new ConfigurationException("URL=" + url + " is invalid");
        }
        this._host = url.substring(schemeIndex + SCHEME_SEPARATOR.length(), hostIndex);
        try {
            int start = hostIndex + HOST_PORT_SEPARATOR.length();
            String port = endIndex == -1 ? url.substring(start) : url.substring(start, endIndex);
            this._port = Integer.parseInt(port);
        }
        catch (Exception exception) {
            throw new ConfigurationException("URL=" + url + " is invalid");
        }
    }

    private Client openConnection() throws NamingException {
        Client client;
        try {
            client = new Client(this._host, this._port);
        }
        catch (Exception exception) {
            NamingException error = new NamingException("Failed to connect to JNDI provider");
            error.setRootCause(exception);
            throw error;
        }
        return client;
    }

    private String getDeprecatedEnvironment(Hashtable environment) {
        _log.warn((Object)(this.getClass().getName() + ": using deprecated environment. Use Context.PROVIDER_URL"));
        StringBuffer url = new StringBuffer(TCP_SCHEME);
        String host = (String)environment.get("org.exolab.jms.jndi.host");
        Integer port = (Integer)environment.get("org.exolab.jms.jndi.port");
        if (host != null) {
            url.append(host);
            url.append(HOST_PORT_SEPARATOR);
        } else {
            url.append("localhost:");
        }
        if (port != null) {
            url.append(port.toString());
        } else {
            url.append("3035");
        }
        return url.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

