/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi.http.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.core.ipc.Client;

public class HttpJmsJndiServlet
extends HttpServlet {
    private static Client connection_ = null;
    private static String serverAddress_ = "127.0.0.1";
    private static int port_ = 3035;
    private static final String CONTENT_TYPE = "text/html";
    private static boolean connected_ = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            String host = config.getInitParameter("org.exolab.jms.jndi.host");
            String port = config.getInitParameter("org.exolab.jms.jndi.port");
            if (host != null) {
                serverAddress_ = host;
            }
            if (port != null) {
                port_ = Integer.parseInt(port);
            }
        }
        this.connect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectInputStream inputStream = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
        response.setContentType(CONTENT_TYPE);
        try {
            try {
                if (!connected_) {
                    this.connect();
                }
                Object o = null;
                o = inputStream.readObject();
                if (o != null && o instanceof Vector) {
                    Client client = connection_;
                    synchronized (client) {
                        try {
                            connection_.send((Serializable)((Vector)o));
                        }
                        catch (Exception err) {
                            connected_ = false;
                            this.connect();
                            connection_.send((Serializable)((Vector)o));
                        }
                        String type = request.getHeader("jms-response");
                        if (type != null && type.equals("yes")) {
                            Vector v = (Vector)connection_.receive();
                            oos.writeObject(v);
                        }
                    }
                    response.setStatus(200);
                }
                response.setStatus(415);
                oos.writeObject("Object is NULL, or UNEXPECTED type");
            }
            catch (Exception e) {
                e.printStackTrace();
                response.setStatus(500);
                oos.writeObject(e.getMessage());
                Object var11_12 = null;
                oos.flush();
                return;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            oos.flush();
            throw throwable;
        }
        oos.flush();
    }

    protected void connect() throws ServletException {
        try {
            connection_ = new Client(serverAddress_, port_);
        }
        catch (Exception err) {
            String message = "HttpJmsJndiServlet: Failed to connect\nReason: " + err.getMessage();
            System.err.println(message);
            throw new ServletException(message);
        }
        System.out.println("JMS JNDI Servlet connected.");
        connected_ = true;
    }

    public void destroy() {
        if (connection_ != null) {
            try {
                try {
                    connection_.close();
                }
                catch (Exception ignored) {
                    Object var3_2 = null;
                    connection_ = null;
                    connected_ = false;
                }
                Object var3_1 = null;
                connection_ = null;
                connected_ = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                connection_ = null;
                connected_ = false;
                throw throwable;
            }
        }
    }

    public String getServletInfo() {
        return "Not implemented yet";
    }
}

