/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.exolab.jms.jndi.http.HttpJndiInitialContextFactory;
import org.exolab.jms.jndi.http.SslHttpJndiInitialContextFactory;
import org.exolab.jms.jndi.intravm.IntravmJndiInitialContextFactory;
import org.exolab.jms.jndi.mipc.IpcJndiInitialContextFactory;
import org.exolab.jms.jndi.rmi.RmiJndiInitialContextFactory;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    public Context getInitialContext(Hashtable environment) throws NamingException {
        javax.naming.spi.InitialContextFactory factory;
        if (environment == null) {
            throw new ConfigurationException("Cannot connect to JNDI provider - environment not set");
        }
        String url = (String)environment.get("java.naming.provider.url");
        if (url == null) {
            throw new ConfigurationException("Connect connect to JNDI provider - java.naming.provider.url not set ");
        }
        if (url.startsWith("rmi")) {
            factory = new RmiJndiInitialContextFactory();
        } else if (url.startsWith("tcp")) {
            factory = new IpcJndiInitialContextFactory();
        } else if (url.startsWith("https")) {
            factory = new SslHttpJndiInitialContextFactory();
        } else if (url.startsWith("http")) {
            factory = new HttpJndiInitialContextFactory();
        } else if (url.startsWith("embedded")) {
            factory = new IntravmJndiInitialContextFactory();
        } else {
            throw new ConfigurationException("Cannot connect to JNDI provider - invalid URL: " + url);
        }
        return factory.getInitialContext(environment);
    }
}

