/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.gc;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.foundation.HandleIfc;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.GarbageCollectionConfiguration;
import org.exolab.jms.events.BasicEventManager;
import org.exolab.jms.events.Event;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.events.IllegalEventDefinedException;
import org.exolab.jms.gc.GarbageCollectable;
import org.exolab.jms.gc.GarbageCollectionServiceException;

public class GarbageCollectionService
extends BasicService
implements EventHandler {
    private static final String GC_SERVICE_NAME = "GCCollectionService";
    private static final int CHECK_FREE_MEMORY_EVENT = 1;
    private static final int GARBAGE_COLLECT_EVENT = 2;
    private static GarbageCollectionService _instance = null;
    private static final Object _creator = new Object();
    private int _gcLowWaterThreshold = 20;
    private int _memoryCheckInterval = 30000;
    private int _gcInterval = 300000;
    private int _gcThreadPriority = 5;
    private final Object _gcGuard = new Object();
    private boolean _collectingGarbage = false;
    private LinkedList _gcList = new LinkedList();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$gc$GarbageCollectionService == null ? (class$org$exolab$jms$gc$GarbageCollectionService = GarbageCollectionService.class$("org.exolab.jms.gc.GarbageCollectionService")) : class$org$exolab$jms$gc$GarbageCollectionService));
    static /* synthetic */ Class class$org$exolab$jms$gc$GarbageCollectionService;

    public static GarbageCollectionService instance() throws GarbageCollectionServiceException {
        if (_instance == null) {
            Object object = _creator;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new GarbageCollectionService();
                }
            }
        }
        return _instance;
    }

    GarbageCollectionService() throws GarbageCollectionServiceException {
        super(GC_SERVICE_NAME);
        Configuration config = ConfigurationManager.getConfig();
        GarbageCollectionConfiguration gc_config = config.getGarbageCollectionConfiguration();
        int low = gc_config.getLowWaterThreshold();
        if (low < 10) {
            low = 10;
        }
        if (low > 50) {
            low = 50;
        }
        this._gcLowWaterThreshold = low;
        int mem_interval = gc_config.getMemoryCheckInterval();
        if (mem_interval > 0 && mem_interval < 5) {
            mem_interval = 5;
        }
        this._memoryCheckInterval = mem_interval * 1000;
        int gc_interval = gc_config.getGarbageCollectionInterval();
        if (gc_interval <= 0) {
            gc_interval = 0;
        }
        this._gcInterval = gc_interval * 1000;
        int gc_priority = gc_config.getGarbageCollectionThreadPriority();
        if (gc_priority < 1) {
            gc_priority = 1;
        }
        if (gc_priority > 10) {
            gc_priority = 10;
        }
        this._gcThreadPriority = gc_priority;
    }

    public boolean belowLowWaterThreshold() {
        boolean result = false;
        long threshold = Runtime.getRuntime().totalMemory() / 100L * (long)this._gcLowWaterThreshold;
        long free = Runtime.getRuntime().freeMemory();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("GC Threshold=" + threshold + " Free=" + free));
        }
        if (threshold > free) {
            result = true;
        }
        return result;
    }

    public void register(GarbageCollectable entry) {
        if (entry != null) {
            LinkedList linkedList = this._gcList;
            synchronized (linkedList) {
                this._gcList.add(entry);
            }
        }
    }

    public void unregister(GarbageCollectable entry) {
        if (entry != null) {
            LinkedList linkedList = this._gcList;
            synchronized (linkedList) {
                this._gcList.remove(entry);
            }
        }
    }

    public void run() {
    }

    public void start() throws ServiceException {
        if (this._memoryCheckInterval > 0) {
            _log.info((Object)("Registering Garbage Collection every " + this._memoryCheckInterval + " for memory."));
            this.registerEvent(1, this._memoryCheckInterval);
        }
        if (this._gcInterval > 0) {
            _log.info((Object)("Registering Garbage Collection every " + this._gcInterval + " for other resources."));
            this.registerEvent(2, this._gcInterval);
        }
        this.setState(ServiceState.RUNNING);
    }

    public void stop() throws ServiceException {
        this.setState(ServiceState.STOPPED);
    }

    public HandleIfc getHandle() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(int event, Object callback, long time) {
        boolean valid_event = false;
        try {
            if (event == 1) {
                valid_event = true;
                try {
                    if (this.belowLowWaterThreshold()) {
                        _log.info((Object)("GC Collecting Garbage Free Heap below " + this._gcLowWaterThreshold));
                        this.collectGarbage(true);
                    }
                }
                catch (Exception exception) {
                    _log.error((Object)"Error in GC Service [CHECK_FREE_MEMORY_EVENT]", (Throwable)exception);
                }
            } else if (event == 2) {
                valid_event = true;
                try {
                    this.collectGarbage(false);
                }
                catch (Exception exception) {
                    _log.error((Object)"Error in GC Service [GARBAGE_COLLECT_EVENT]", (Throwable)exception);
                }
            }
            Object var8_7 = null;
            if (!valid_event) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!valid_event) throw throwable;
            try {
                this.registerEvent(event, (Long)callback);
                throw throwable;
            }
            catch (Exception exception) {
                _log.error((Object)"Error in GC Service", (Throwable)exception);
            }
            throw throwable;
        }
        try {
            this.registerEvent(event, (Long)callback);
            return;
        }
        catch (Exception exception) {
            _log.error((Object)"Error in GC Service", (Throwable)exception);
        }
    }

    private void collectGarbage(boolean aggressive) {
        Object object = this._gcGuard;
        synchronized (object) {
            if (this._collectingGarbage) {
                return;
            }
            this._collectingGarbage = true;
        }
        int oldPriority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(this._gcThreadPriority);
            Object[] list = this._gcList.toArray();
            int index = 0;
            while (index < list.length) {
                try {
                    GarbageCollectable collectable = (GarbageCollectable)list[index];
                    collectable.collectGarbage(aggressive);
                }
                catch (Exception exception) {
                    _log.error((Object)"Error while collecting garbage", (Throwable)exception);
                }
                ++index;
            }
            Object var8_9 = null;
            Thread.currentThread().setPriority(oldPriority);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Thread.currentThread().setPriority(oldPriority);
            throw throwable;
        }
        Object object2 = this._gcGuard;
        synchronized (object2) {
            this._collectingGarbage = false;
        }
    }

    private void registerEvent(int event, long time) throws GarbageCollectionServiceException {
        try {
            BasicEventManager.instance().registerEventRelative(new Event(event, this, new Long(time)), time);
        }
        catch (IllegalEventDefinedException exception) {
            throw new GarbageCollectionServiceException("Failed to registerEvent " + exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

