/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.rmi.RemoteJmsMessageListenerIfc;
import org.exolab.jms.server.rmi.RemoteJmsServerSessionIfc;

public class RmiJmsSessionStub
extends UnicastRemoteObject
implements JmsSessionStubIfc,
RemoteJmsMessageListenerIfc {
    private JmsMessageListener _listener = null;
    private RemoteJmsServerSessionIfc _delegate = null;

    protected RmiJmsSessionStub(RemoteJmsServerSessionIfc session) throws JMSException, RemoteException {
        if (session == null) {
            throw new JMSException("Cannot create session stub with a null session");
        }
        this._delegate = session;
    }

    public String getClientId() throws JMSException {
        try {
            return this._delegate.getClientId();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to getClientId  " + exception);
        }
    }

    public String getSessionId() throws JMSException {
        try {
            return this._delegate.getSessionId();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to getSessionId  " + exception);
        }
    }

    public void beforeClose() throws JMSException {
    }

    public void close() throws JMSException {
        try {
            this._delegate.close();
            UnicastRemoteObject.unexportObject(this, true);
            this._delegate = null;
            this._listener = null;
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to close  " + exception);
        }
    }

    public void acknowledgeMessage(long clientId, String messageId) throws JMSException {
        try {
            this._delegate.acknowledgeMessage(clientId, messageId);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to acknowledgeMessage  " + exception);
        }
    }

    public void sendMessage(Message message) throws JMSException {
        try {
            this._delegate.sendMessage(message);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to sendMessage  " + exception);
        }
    }

    public void sendMessages(Vector messages) throws JMSException {
        try {
            this._delegate.sendMessages(messages);
        }
        catch (RemoteException exception) {
            exception.printStackTrace();
            throw new JMSException("Failed to sendMessages  " + exception);
        }
    }

    public Message receiveMessage(long clientId, long wait) throws JMSException {
        try {
            return this._delegate.receiveMessage(clientId, wait);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to receiveMessage " + exception);
        }
    }

    public Vector receiveMessages(long clientId, int count) throws JMSException {
        try {
            return this._delegate.receiveMessages(clientId, count);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to receiveMessages " + exception);
        }
    }

    public void createQueue(JmsQueue queue) throws JMSException {
        try {
            this._delegate.createQueue(queue);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createQueue  " + exception);
        }
    }

    public void createTopic(JmsTopic topic) throws JMSException {
        try {
            this._delegate.createTopic(topic);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createTopic  " + exception);
        }
    }

    public void createReceiver(JmsQueue queue, long clientId, String selector) throws JMSException {
        try {
            this._delegate.createReceiver(queue, clientId, selector);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createReceiver  " + exception);
        }
    }

    public void createSender(JmsQueue queue) throws JMSException {
        try {
            this._delegate.createSender(queue);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createReceiver  " + exception);
        }
    }

    public void createBrowser(JmsQueue queue, long clientId, String selector) throws JMSException {
        try {
            this._delegate.createBrowser(queue, clientId, selector);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createBrowser  " + exception);
        }
    }

    public void deleteReceiver(long clientId) throws JMSException {
        try {
            this._delegate.deleteReceiver(clientId);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to deleteReceiver  " + exception);
        }
    }

    public void deleteSender(long clientId) throws JMSException {
        try {
            this._delegate.deleteSender(clientId);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to deleteSender  " + exception);
        }
    }

    public void deleteBrowser(long clientId) throws JMSException {
        try {
            this._delegate.deleteBrowser(clientId);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to deleteBrowser  " + exception);
        }
    }

    public void createSubscriber(JmsTopic topic, String name, long clientId, String selector, boolean noLocal) throws JMSException {
        try {
            this._delegate.createSubscriber(topic, name, clientId, selector, noLocal);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createSubscriber  " + exception);
        }
    }

    public void createPublisher(JmsTopic topic) throws JMSException {
        try {
            this._delegate.createPublisher(topic);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createPublisher  " + exception);
        }
    }

    public void deleteSubscriber(long clientId) throws JMSException {
        try {
            this._delegate.deleteSubscriber(clientId);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to deleteSubscriber  " + exception);
        }
    }

    public void deletePublisher(JmsTopic topic) throws JMSException {
        try {
            this._delegate.deletePublisher(topic);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to deletePublisher  " + exception);
        }
    }

    public void unsubscribe(String name) throws JMSException {
        try {
            this._delegate.unsubscribe(name);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to unsubscribe  " + exception);
        }
    }

    public void stopMessageDelivery() throws JMSException {
        try {
            this._delegate.stopMessageDelivery();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to stopMessageDelivery  " + exception);
        }
    }

    public void startMessageDelivery() throws JMSException {
        try {
            this._delegate.startMessageDelivery();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to startMessageDelivery  " + exception);
        }
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._listener = listener;
    }

    public void enableAsynchronousDelivery(long clientId, String id, boolean enable) throws JMSException {
        try {
            this._delegate.enableAsynchronousDelivery(clientId, id, enable);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to enableAsynchronousDelivery  " + exception);
        }
    }

    public void recover() throws JMSException {
        try {
            this._delegate.recover();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to recover session " + exception);
        }
    }

    public void commit() throws JMSException {
        try {
            this._delegate.commit();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to commit session " + exception);
        }
    }

    public void rollback() throws JMSException {
        try {
            this._delegate.rollback();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to rollback session " + exception);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this._delegate.commit(xid, onePhase);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to commit session " + exception);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this._delegate.end(xid, flags);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to end session " + exception);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this._delegate.forget(xid);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to forget session " + exception);
        }
    }

    public String getResourceManagerId() throws XAException {
        try {
            return this._delegate.getResourceManagerId();
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to getResourceManagerId " + exception);
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return this._delegate.getTransactionTimeout();
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to getTransactionTimeout " + exception);
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this._delegate.prepare(xid);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to prepare session " + exception);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return this._delegate.recover(flag);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to recover session " + exception);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this._delegate.rollback(xid);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to rollback session " + exception);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return this._delegate.setTransactionTimeout(seconds);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to setTransactionTimeout " + exception);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this._delegate.start(xid, flags);
        }
        catch (RemoteException exception) {
            throw new XAException("Failed to start session " + exception);
        }
    }

    public void onMessage(Message message) throws RemoteException {
        if (message == null) {
            return;
        }
        this._listener.onMessage(message);
    }

    public void onMessages(Vector messages) throws RemoteException {
        this._listener.onMessages(messages);
    }

    public void onMessageAvailable(long clientId) throws RemoteException {
        this._listener.onMessageAvailable(clientId);
    }
}

