/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsServerStubIfc;
import org.exolab.jms.client.rmi.RmiJmsConnectionStub;
import org.exolab.jms.server.rmi.RemoteJmsServerConnectionIfc;
import org.exolab.jms.server.rmi.RemoteJmsServerIfc;

public class RmiJmsServerStub
implements JmsServerStubIfc {
    private RemoteJmsServerIfc _delegate = null;
    private final String _serverURL;
    private ExceptionListener _listener = null;
    private final int _pingInterval;

    public RmiJmsServerStub(Hashtable environment) {
        if (environment == null) {
            throw new IllegalArgumentException("Argument environment is null");
        }
        this._serverURL = (String)environment.get("org.exolab.jms.rmi.server");
        if (this._serverURL == null) {
            throw new IllegalArgumentException("Environment does not contain property org.exolab.jms.rmi.server");
        }
        String interval = (String)environment.get("org.exolab.jms.rmi.server.client_ping_interval");
        if (interval == null) {
            throw new IllegalArgumentException("Environment does not contain property org.exolab.jms.rmi.server.client_ping_interval");
        }
        try {
            this._pingInterval = Integer.parseInt(interval);
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Property org.exolab.jms.rmi.server.client_ping_interval is invalid, value=" + interval);
        }
    }

    public synchronized RemoteJmsServerIfc getDelegate() throws JMSException {
        if (this._delegate == null) {
            try {
                this._delegate = (RemoteJmsServerIfc)Naming.lookup(this._serverURL);
            }
            catch (Exception exception) {
                String msg = "Failed to locate server, url=" + this._serverURL + ": " + exception.getMessage();
                JMSException error = new JMSException(msg);
                error.setLinkedException((Exception)((Object)error));
                throw error;
            }
        }
        return this._delegate;
    }

    public JmsConnectionStubIfc createConnection(String id, String username, String password) throws JMSException {
        RmiJmsConnectionStub stub = null;
        try {
            RemoteJmsServerConnectionIfc connection = this.getDelegate().createConnection(id, username, password);
            if (connection == null) {
                throw new JMSException("Failed to create remote connection");
            }
            stub = new RmiJmsConnectionStub(connection, this._pingInterval, this);
        }
        catch (RemoteException exception) {
            JMSException error = new JMSException("Failed to create connection: " + exception.getMessage());
            error.setLinkedException((Exception)exception);
            throw error;
        }
        return stub;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this._listener = listener;
    }

    public ExceptionListener getExceptionListener() {
        return this._listener;
    }
}

