/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.intravm;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.server.JmsServerSession;

public class IntravmJmsSessionStub
implements JmsSessionStubIfc,
JmsMessageListener {
    private JmsMessageListener _listener = null;
    private JmsServerSession _delegate = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$intravm$IntravmJmsSessionStub == null ? (class$org$exolab$jms$client$intravm$IntravmJmsSessionStub = IntravmJmsSessionStub.class$("org.exolab.jms.client.intravm.IntravmJmsSessionStub")) : class$org$exolab$jms$client$intravm$IntravmJmsSessionStub));
    static /* synthetic */ Class class$org$exolab$jms$client$intravm$IntravmJmsSessionStub;

    IntravmJmsSessionStub(JmsServerSession session) throws JMSException {
        if (session == null) {
            throw new JMSException("Cannot create session stub with a null session");
        }
        this._delegate = session;
    }

    public String getClientId() throws JMSException {
        return this._delegate.getClientId();
    }

    public String getSessionId() throws JMSException {
        return this._delegate.getSessionId();
    }

    public void beforeClose() throws JMSException {
    }

    public void close() throws JMSException {
        this._delegate.close();
    }

    public void acknowledgeMessage(long clientId, String messageId) throws JMSException {
        this._delegate.acknowledgeMessage(clientId, messageId);
    }

    public void sendMessage(Message message) throws JMSException {
        Message copy = null;
        try {
            copy = (Message)((MessageImpl)message).clone();
        }
        catch (CloneNotSupportedException exception) {
            JMSException error = new JMSException(exception.getMessage());
            error.setLinkedException((Exception)exception);
            throw error;
        }
        this._delegate.sendMessage(copy);
    }

    public void sendMessages(Vector messages) throws JMSException {
        this._delegate.sendMessages(messages);
    }

    public Message receiveMessage(long clientId, long wait) throws JMSException {
        Message message = this._delegate.receiveMessage(clientId, wait);
        Message copy = null;
        if (message != null) {
            try {
                copy = (Message)((MessageImpl)message).clone();
            }
            catch (CloneNotSupportedException exception) {
                JMSException error = new JMSException(exception.getMessage());
                error.setLinkedException((Exception)exception);
                throw error;
            }
        }
        return copy;
    }

    public Vector receiveMessages(long clientId, int count) throws JMSException {
        Vector messages = this._delegate.receiveMessages(clientId, count);
        Vector<MessageImpl> copied = new Vector<MessageImpl>();
        if (messages.size() > 0) {
            int index = 0;
            while (index < messages.size()) {
                MessageImpl copy = null;
                MessageImpl message = (MessageImpl)messages.elementAt(index);
                try {
                    copy = (MessageImpl)message.clone();
                    copied.addElement(copy);
                }
                catch (CloneNotSupportedException exception) {
                    JMSException error = new JMSException(exception.getMessage());
                    error.setLinkedException((Exception)exception);
                    throw error;
                }
                ++index;
            }
        }
        return copied;
    }

    public void createQueue(JmsQueue queue) throws JMSException {
        this._delegate.createQueue(queue);
    }

    public void createTopic(JmsTopic topic) throws JMSException {
        this._delegate.createTopic(topic);
    }

    public void createReceiver(JmsQueue queue, long clientId, String selector) throws JMSException {
        this._delegate.createReceiver(queue, clientId, selector);
    }

    public void createSender(JmsQueue queue) throws JMSException {
        this._delegate.createSender(queue);
    }

    public void createBrowser(JmsQueue queue, long clientId, String selector) throws JMSException {
        this._delegate.createBrowser(queue, clientId, selector);
    }

    public void deleteReceiver(long clientId) throws JMSException {
        this._delegate.deleteReceiver(clientId);
    }

    public void deleteBrowser(long clientId) throws JMSException {
        this._delegate.deleteBrowser(clientId);
    }

    public void createSubscriber(JmsTopic topic, String name, long clientId, String selector, boolean noLocal) throws JMSException {
        this._delegate.createSubscriber(topic, name, clientId, selector, noLocal);
    }

    public void createPublisher(JmsTopic topic) throws JMSException {
        this._delegate.createPublisher(topic);
    }

    public void deleteSubscriber(long clientId) throws JMSException {
        this._delegate.deleteSubscriber(clientId);
    }

    public void unsubscribe(String name) throws JMSException {
        this._delegate.unsubscribe(name);
    }

    public void stopMessageDelivery() throws JMSException {
        this._delegate.stopMessageDelivery();
    }

    public void startMessageDelivery() throws JMSException {
        this._delegate.startMessageDelivery();
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._listener = listener;
    }

    public void enableAsynchronousDelivery(long clientId, String id, boolean enable) throws JMSException {
        this._delegate.enableAsynchronousDelivery(clientId, id, enable);
    }

    public void recover() throws JMSException {
        this._delegate.recover();
    }

    public void commit() throws JMSException {
        this._delegate.commit();
    }

    public void rollback() throws JMSException {
        this._delegate.rollback();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this._delegate.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this._delegate.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this._delegate.forget(xid);
    }

    public String getResourceManagerId() throws XAException {
        return this._delegate.getResourceManagerId();
    }

    public int getTransactionTimeout() throws XAException {
        return this._delegate.getTransactionTimeout();
    }

    public int prepare(Xid xid) throws XAException {
        return this._delegate.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this._delegate.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this._delegate.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._delegate.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this._delegate.start(xid, flags);
    }

    public void onMessage(Message message) {
        if (message != null) {
            Message copy = null;
            try {
                copy = (Message)((MessageImpl)message).clone();
            }
            catch (CloneNotSupportedException exception) {
                _log.error((Object)exception);
            }
            this._listener.onMessage(copy);
        }
    }

    public void onMessages(Vector messages) {
        Vector<Object> copy = new Vector<Object>();
        try {
            Iterator iter = ((AbstractList)messages).iterator();
            while (iter.hasNext()) {
                MessageImpl message = (MessageImpl)iter.next();
                copy.add(message.clone());
            }
        }
        catch (CloneNotSupportedException exception) {
            _log.error((Object)exception);
        }
        this._listener.onMessages(copy);
    }

    public void onMessageAvailable(long clientId) {
        this._listener.onMessageAvailable(clientId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

