/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.http;

import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.http.HttpJmsServerStub;

public class SslHttpJmsServerStub
extends HttpJmsServerStub {
    public SslHttpJmsServerStub(Hashtable env) throws JMSException {
        String url = (String)env.get("org.exolab.jms.http.server.url");
        if (url == null) {
            throw new JMSException("Required property not specified: org.exolab.jms.http.server.url");
        }
        this.setURL(url);
        this.setLabel("SslHttpJmsServerStub");
    }

    public SslHttpJmsServerStub(String url) {
        super(url);
        this.setLabel("SslHttpJmsServerStub");
    }

    public JmsConnectionStubIfc createConnection(String clientId, String username, String password) throws JMSException {
        Object stub = null;
        try {
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Class<?> providerClass = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            Provider provider = (Provider)providerClass.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception exception) {
            throw new JMSException("Failed to initialise SSL: " + exception);
        }
        return super.createConnection(clientId, username, password);
    }
}

