/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.http.HttpClient;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.core.ipc.NotifierIfc;
import org.exolab.core.ipc.Server;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;

public class HttpJmsSessionStub
implements JmsSessionStubIfc,
NotifierIfc {
    private IpcIfc _connection = null;
    private String _clientId;
    private String _connectionId;
    private String _sessionId;
    private Server _msgReceiver = null;
    private JmsMessageListener _listener = null;
    private String _url;
    private String _host = "localhost";
    private static final String CLIENT_SERVLET = "openjms/OpenJMSClient";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$http$HttpJmsSessionStub == null ? (class$org$exolab$jms$client$http$HttpJmsSessionStub = HttpJmsSessionStub.class$("org.exolab.jms.client.http.HttpJmsSessionStub")) : class$org$exolab$jms$client$http$HttpJmsSessionStub));
    static /* synthetic */ Class class$org$exolab$jms$client$http$HttpJmsSessionStub;

    public HttpJmsSessionStub(IpcIfc connection, String clientId, String connectionId, String sessionId) {
        String clientWebServerURL;
        this._connection = connection;
        this._clientId = clientId;
        this._connectionId = connectionId;
        this._sessionId = sessionId;
        Object str = null;
        String clientHost = System.getProperty("org.exolab.jms.jndi.http.client.address");
        if (clientHost != null) {
            this._host = clientHost;
        }
        if (this._host.equals("localhost")) {
            try {
                this._host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ignore) {
                // empty catch block
            }
        }
        if ((clientWebServerURL = System.getProperty("org.exolab.jms.jndi.http_client_url")) == null) {
            URL url = ((HttpClient)this._connection).getURL();
            clientWebServerURL = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/";
        }
        if (!clientWebServerURL.endsWith("/")) {
            clientWebServerURL = clientWebServerURL + "/";
        }
        this._url = clientWebServerURL + CLIENT_SERVLET;
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public void beforeClose() throws JMSException {
    }

    public void close() throws JMSException {
        Vector v = this.pack("close", 0);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("close");
        }
        this._listener = null;
        if (this._msgReceiver != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Stopping receiver on port=" + this._msgReceiver.getPort()));
            }
            this._msgReceiver.stop();
            this._msgReceiver = null;
        }
    }

    public void acknowledgeMessage(long clientId, String messageId) throws JMSException {
        Vector v = this.pack("acknowledgeMessage", 2);
        v.add(new Long(clientId));
        v.add(messageId);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("acknowledgeMessage");
        }
    }

    public void sendMessage(Message message) throws JMSException {
        Vector v = this.pack("sendMessage", 1);
        v.add(message);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            if (((MessageImpl)message).isPersistent()) {
                this.send(v, true);
                this.checkReply("sendMessage");
            } else {
                this.send(v, false);
            }
        }
    }

    public void sendMessages(Vector messages) throws JMSException {
        Vector v = this.pack("sendMessages", 1);
        v.add(messages);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("sendMessages");
        }
    }

    public Message receiveMessage(long clientId, long wait) throws JMSException {
        Message message = null;
        Vector v = this.pack("receiveMessage", 2);
        v.add(new Long(clientId));
        v.add(new Long(wait));
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            Vector reply = this.checkReply("receiveMessage");
            Boolean result = (Boolean)reply.get(0);
            if (result.booleanValue()) {
                message = (Message)reply.get(1);
            }
        }
        return message;
    }

    public Vector receiveMessages(long clientId, int count) throws JMSException {
        Vector messages = null;
        Vector v = this.pack("receiveMessages", 2);
        v.add(new Long(clientId));
        v.add(new Integer(count));
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            Vector reply = this.checkReply("receiveMessages");
            Boolean result = (Boolean)reply.get(0);
            if (result.booleanValue()) {
                messages = (Vector)reply.get(1);
            }
        }
        return messages;
    }

    public void createQueue(JmsQueue queue) throws JMSException {
        Vector v = this.pack("createQueue", 1);
        v.add(queue);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createQueue");
        }
    }

    public void createTopic(JmsTopic topic) throws JMSException {
        Vector v = this.pack("createTopic", 1);
        v.add(topic);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createTopic");
        }
    }

    public void createReceiver(JmsQueue queue, long clientId, String selector) throws JMSException {
        this.startReceiver();
        Vector v = this.pack("createReceiver", 6);
        v.add(queue);
        v.add(new Long(clientId));
        v.add(selector);
        v.add(this._host);
        v.add(String.valueOf(this._msgReceiver.getPort()));
        v.add(this._url);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createReceiver");
        }
    }

    public void createSender(JmsQueue queue) throws JMSException {
        Vector v = this.pack("createSender", 1);
        v.add(queue);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createSender");
        }
    }

    public void createBrowser(JmsQueue queue, long clientId, String selector) throws JMSException {
        this.startReceiver();
        Vector v = this.pack("createBrowser", 6);
        v.add(queue);
        v.add(new Long(clientId));
        v.add(selector);
        v.add(this._host);
        v.add(String.valueOf(this._msgReceiver.getPort()));
        v.add(this._url);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createBrowser");
        }
    }

    public void deleteReceiver(long clientId) throws JMSException {
        Vector v = this.pack("deleteReceiver", 1);
        v.add(new Long(clientId));
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("deleteReceiver");
        }
    }

    public void deleteBrowser(long clientId) throws JMSException {
        Vector v = this.pack("deleteBrowser", 1);
        v.add(new Long(clientId));
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("deleteBrowser");
        }
    }

    public void createSubscriber(JmsTopic topic, String name, long clientId, String selector, boolean noLocal) throws JMSException {
        this.startReceiver();
        Vector v = this.pack("createSubscriber", 8);
        v.add(topic);
        v.add(name);
        v.add(new Long(clientId));
        v.add(selector);
        v.add(new Boolean(noLocal));
        v.add(this._host);
        v.add(String.valueOf(this._msgReceiver.getPort()));
        v.add(this._url);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createSubscriber");
        }
    }

    public void createPublisher(JmsTopic topic) throws JMSException {
        Vector v = this.pack("createPublisher", 1);
        v.add(topic);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("createPublisher");
        }
    }

    public void unsubscribe(String name) throws JMSException {
        Vector v = this.pack("unsubscribe", 1);
        v.add(name);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("unsubscribe");
        }
    }

    public void deleteSubscriber(long clientId) throws JMSException {
        Vector v = this.pack("deleteSubscriber", 1);
        v.add(new Long(clientId));
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("deleteSubscriber");
        }
    }

    public void stopMessageDelivery() throws JMSException {
        Vector v = this.pack("stopMessageDelivery", 0);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("stopMessageDelivery");
        }
    }

    public void startMessageDelivery() throws JMSException {
        Vector v = this.pack("startMessageDelivery", 0);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("startMessageDelivery");
        }
    }

    public void recover() throws JMSException {
        Vector v = this.pack("recover", 0);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("recover");
        }
    }

    public void commit() throws JMSException {
        Vector v = this.pack("commit", 0);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("commit");
        }
    }

    public void rollback() throws JMSException {
        Vector v = this.pack("rollback", 0);
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("rollback");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            Vector v = this.pack("xa_commit", 2);
            v.add(xid);
            v.add(new Boolean(onePhase));
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                this.checkReply("xa_commit");
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to commit session " + (Object)((Object)exception));
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            Vector v = this.pack("xa_end", 2);
            v.add(xid);
            v.add(new Integer(flags));
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                this.checkReply("xa_end");
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to commit session " + (Object)((Object)exception));
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            Vector v = this.pack("xa_forget", 1);
            v.add(xid);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                this.checkReply("xa_forget");
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to commit session " + (Object)((Object)exception));
        }
    }

    public int getTransactionTimeout() throws XAException {
        int timeout = 0;
        try {
            Vector v = this.pack("xa_getTransactionTimeout", 0);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                Vector reply = this.checkReply("xa_getTransactionTimeout");
                Boolean result = (Boolean)reply.get(0);
                if (result.booleanValue()) {
                    timeout = (Integer)reply.get(1);
                }
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to getTransactionTimeout session " + (Object)((Object)exception));
        }
        return timeout;
    }

    public int prepare(Xid xid) throws XAException {
        int value = 0;
        try {
            Vector v = this.pack("xa_prepare", 1);
            v.add(xid);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                Vector reply = this.checkReply("xa_prepare");
                Boolean result = (Boolean)reply.get(0);
                if (result.booleanValue()) {
                    value = (Integer)reply.get(1);
                }
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to prepare session " + (Object)((Object)exception));
        }
        return value;
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] xids = new Xid[]{};
        try {
            Vector v = this.pack("xa_recover", 1);
            v.add(new Integer(flag));
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                Vector reply = this.checkReply("xa_recover");
                Boolean result = (Boolean)reply.get(0);
                if (result.booleanValue()) {
                    xids = (Xid[])reply.get(1);
                }
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to recover session " + (Object)((Object)exception));
        }
        return xids;
    }

    public void rollback(Xid xid) throws XAException {
        try {
            Vector v = this.pack("xa_rollback", 1);
            v.add(xid);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                this.checkReply("xa_rollback");
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to rollback session " + (Object)((Object)exception));
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        boolean value = false;
        try {
            Vector v = this.pack("xa_setTransactionTimeout", 1);
            v.add(new Integer(seconds));
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                Vector reply = this.checkReply("xa_setTransactionTimeout");
                Boolean result = (Boolean)reply.get(0);
                if (result.booleanValue()) {
                    value = (Boolean)reply.get(1);
                }
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to setTransactionTimeout " + (Object)((Object)exception));
        }
        return value;
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            Vector v = this.pack("xa_start", 2);
            v.add(xid);
            v.add(new Integer(flags));
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                this.checkReply("xa_start");
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to start session " + (Object)((Object)exception));
        }
    }

    public String getResourceManagerId() throws XAException {
        String rid = null;
        try {
            Vector v = this.pack("xa_getResourceManagerId", 0);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this.send(v, true);
                Vector reply = this.checkReply("xa_getResourceManagerId");
                Boolean result = (Boolean)reply.get(0);
                if (result.booleanValue()) {
                    rid = (String)reply.get(1);
                }
            }
        }
        catch (JMSException exception) {
            throw new XAException("Failed to getResourceManagerId " + (Object)((Object)exception));
        }
        return rid;
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._listener = listener;
    }

    public void enableAsynchronousDelivery(long clientId, String id, boolean enable) throws JMSException {
        Vector v = this.pack("enableAsynchronousDelivery", 3);
        v.add(new Long(clientId));
        v.add(id);
        v.add(new Boolean(enable));
        IpcIfc ipcIfc = this._connection;
        synchronized (ipcIfc) {
            this.send(v, true);
            this.checkReply("enableAsynchronousDelivery");
        }
    }

    public synchronized void stopReceiver() {
        this._listener = null;
        if (this._msgReceiver != null) {
            this._msgReceiver.stop();
            this._msgReceiver = null;
        }
    }

    private Vector pack(String method, int numParams) {
        Vector<String> v = new Vector<String>(5 + numParams);
        v.add("org.exolab.jms.server.http.HttpJmsSessionConnection");
        this.packCommon(v, method);
        return v;
    }

    private void packCommon(Vector v, String method) {
        v.add(method);
        v.add(this._clientId);
        v.add(this._connectionId);
        v.add(this._sessionId);
    }

    private Vector checkReply(String method) throws JMSException {
        Vector v = null;
        try {
            v = (Vector)this._connection.receive();
        }
        catch (Exception err) {
            throw new JMSException("Operation " + method + " failed: " + err);
        }
        if (v != null) {
            Boolean b = (Boolean)v.get(0);
            if (!b.booleanValue()) {
                if (v.get(1) instanceof JMSException) {
                    throw (JMSException)((Object)v.get(1));
                }
                throw new JMSException("Operation " + method + " failed: " + v.get(1));
            }
        } else {
            throw new JMSException("Unknown connection error for " + method);
        }
        return v;
    }

    public Serializable notify(Object ob, String id) {
        Vector v = (Vector)ob;
        Vector reply = new Vector();
        if (this._listener != null && v.size() == 2) {
            if (v.get(1) instanceof Message) {
                this._listener.onMessage((Message)v.get(1));
            } else if (v.get(1) instanceof Vector) {
                this._listener.onMessages((Vector)v.get(1));
            } else if (v.get(1) instanceof Long) {
                this._listener.onMessageAvailable((Long)v.get(1));
            }
        }
        return reply;
    }

    public void disconnection(String id) {
    }

    private void send(Vector v, boolean replyExpected) throws JMSException {
        try {
            if (replyExpected) {
                this._connection.send((Serializable)v);
            } else {
                ((HttpClient)this._connection).sendWithoutResponse((Serializable)v);
            }
        }
        catch (Exception err) {
            throw new JMSException("Operation Failed" + err);
        }
    }

    private synchronized void startReceiver() throws JMSException {
        try {
            if (this._msgReceiver == null) {
                this._msgReceiver = new Server((NotifierIfc)this);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Starting receiver on port=" + this._msgReceiver.getPort()));
                }
                new Thread((Runnable)this._msgReceiver).start();
            }
        }
        catch (Exception err) {
            throw new JMSException(err.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

