/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.http;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.http.HttpJmsSessionStub;

public class HttpJmsConnectionStub
implements JmsConnectionStubIfc {
    private IpcIfc _connection = null;
    private String _clientId;
    private String _connectionId;
    Vector _sessions = new Vector();

    public HttpJmsConnectionStub(IpcIfc connection, String clientId, String connectionId) throws JMSException {
        if (connection == null) {
            throw new JMSException("Cannot instantiate with a null connection");
        }
        this._connection = connection;
        this._clientId = clientId;
        this._connectionId = connectionId;
    }

    public JmsSessionStubIfc createSession(int ackMode, boolean transacted) throws JMSException {
        HttpJmsSessionStub stub = null;
        try {
            Vector v = this.pack("createSession", 2);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                v.add(new Integer(ackMode));
                v.add(new Boolean(transacted));
                this._connection.send((Serializable)v);
                v = this.checkReply("createSession");
            }
            Vector state = (Vector)v.get(1);
            String sessionId = (String)state.get(0);
            stub = new HttpJmsSessionStub(this._connection, this._clientId, this._connectionId, sessionId);
            this._sessions.add(stub);
        }
        catch (JMSException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new JMSException("Failed to create session: " + exception);
        }
        return stub;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        Enumeration e2;
        try {
            try {
                Vector v = this.pack("close", 0);
                IpcIfc ipcIfc = this._connection;
                synchronized (ipcIfc) {
                    this._connection.send((Serializable)v);
                    v = this.checkReply("close");
                }
            }
            catch (JMSException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new JMSException("Failed to close: " + exception);
            }
            Object var5_5 = null;
            this._connection = null;
            Enumeration e2 = this._sessions.elements();
            while (e2.hasMoreElements()) {
                ((HttpJmsSessionStub)e2.nextElement()).stopReceiver();
            }
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._connection = null;
            e2 = this._sessions.elements();
        }
        while (true) {
            if (!e2.hasMoreElements()) {
                throw throwable;
            }
            ((HttpJmsSessionStub)e2.nextElement()).stopReceiver();
        }
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    public void destroy() {
        this._connection = null;
    }

    private Vector pack(String method, int numParams) {
        Vector<String> v = new Vector<String>(4 + numParams);
        v.add("org.exolab.jms.server.mipc.IpcJmsServerConnection");
        v.add(method);
        v.add(this._clientId);
        v.add(this._connectionId);
        return v;
    }

    private Vector checkReply(String method) throws JMSException {
        Vector v = null;
        try {
            v = (Vector)this._connection.receive();
        }
        catch (Exception exception) {
            throw new JMSException("Operation " + method + " failed: " + exception);
        }
        if (v != null) {
            Boolean b = (Boolean)v.get(0);
            if (!b.booleanValue()) {
                if (v.get(1) instanceof JMSException) {
                    throw (JMSException)((Object)v.get(1));
                }
                throw new JMSException("Operation " + method + " failed: " + v.get(1));
            }
        } else {
            throw new JMSException("Unknown connection error for " + method);
        }
        return v;
    }
}

