/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.exolab.jms.client.JmsMessageConsumer;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.JmsTopicSession;

class JmsTopicSubscriber
extends JmsMessageConsumer
implements TopicSubscriber {
    private JmsTopic _topic = null;
    private boolean _noLocal = false;
    private String _name = null;

    public JmsTopicSubscriber(JmsSession session, long clientId, JmsTopic topic, String selector, boolean noLocal, String name) throws InvalidDestinationException {
        super(session, clientId, selector);
        if (topic == null) {
            throw new InvalidDestinationException("Argument 'topic' is null");
        }
        this._topic = topic;
        this._noLocal = noLocal;
        this._name = name;
    }

    public Topic getTopic() {
        return this._topic;
    }

    public boolean getNoLocal() {
        return this._noLocal;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDurableSubscriber() {
        return this._name != null && this._name.length() > 0;
    }

    public synchronized void close() throws JMSException {
        if (!this.isClosed()) {
            JmsTopicSession session = (JmsTopicSession)this.getSession();
            session.removeSubscriber(this);
            super.close();
        }
    }

    public synchronized void destroy() throws JMSException {
        this._topic = null;
        super.destroy();
    }
}

