/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.exolab.jms.client.JmsConnectionConsumer;

class JmsTopicConnectionConsumer
extends JmsConnectionConsumer {
    private TopicSession _session;
    private TopicSubscriber _subscriber;

    public JmsTopicConnectionConsumer(TopicConnection connection, Topic topic, ServerSessionPool pool, String selector, int maxMessages) throws JMSException {
        this(connection, topic, null, pool, selector, maxMessages);
    }

    public JmsTopicConnectionConsumer(TopicConnection connection, Topic topic, String subscriptionName, ServerSessionPool pool, String selector, int maxMessages) throws JMSException {
        super(pool, maxMessages);
        this._session = connection.createTopicSession(false, 2);
        this._subscriber = subscriptionName == null ? this._session.createSubscriber(topic, selector, false) : this._session.createDurableSubscriber(topic, subscriptionName, selector, false);
        this._subscriber.setMessageListener((MessageListener)this);
    }

    public void close() throws JMSException {
        super.close();
        try {
            this._subscriber.close();
            this._session.close();
            Object var2_1 = null;
            this._subscriber = null;
            this._session = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._subscriber = null;
            this._session = null;
            throw throwable;
        }
    }
}

