/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsConnection;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsMessageConsumer;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsMessageProducer;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.message.BytesMessageImpl;
import org.exolab.jms.message.MapMessageImpl;
import org.exolab.jms.message.MessageConverter;
import org.exolab.jms.message.MessageConverterFactory;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.message.MessageSessionIfc;
import org.exolab.jms.message.ObjectMessageImpl;
import org.exolab.jms.message.StreamMessageImpl;
import org.exolab.jms.message.TextMessageImpl;

abstract class JmsSession
implements Session,
JmsMessageListener,
MessageSessionIfc {
    private volatile boolean _closed = false;
    private volatile boolean _closing = false;
    private volatile boolean _stopped = true;
    private volatile boolean _started = false;
    private final boolean _transacted;
    private final int _ackMode;
    private JmsConnection _connection;
    private Hashtable _consumers = new Hashtable();
    private Vector _producers = new Vector();
    private Vector _messagesToSend = new Vector();
    private final String _sessionId;
    private JmsSessionStubIfc _stub = null;
    private MessageListener _listener = null;
    private long _consumerIdSeed = 0L;
    private long _publishCount;
    private Vector _messageCache = new Vector();
    private final Object _receiveLock = new Object();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsSession == null ? (class$org$exolab$jms$client$JmsSession = JmsSession.class$("org.exolab.jms.client.JmsSession")) : class$org$exolab$jms$client$JmsSession));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsSession;

    public JmsSession(JmsConnection connection, boolean transacted, int ackMode) throws JMSException {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        this._connection = connection;
        this._transacted = transacted;
        this._ackMode = ackMode;
        this._stub = connection.getJmsConnectionStub().createSession(this._ackMode, transacted);
        this._sessionId = this._stub.getSessionId();
        this._stub.setMessageListener(this);
        if (!connection.isStopped()) {
            this.start();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.ensureOpen();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.ensureOpen();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.ensureOpen();
        return new MessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.ensureOpen();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.ensureOpen();
        ObjectMessageImpl result = new ObjectMessageImpl();
        result.setObject(object);
        return result;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.ensureOpen();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.ensureOpen();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.ensureOpen();
        TextMessageImpl result = new TextMessageImpl();
        result.setText(text);
        return result;
    }

    public boolean getTransacted() throws JMSException {
        this.ensureOpen();
        return this._transacted;
    }

    public synchronized void commit() throws JMSException {
        this.ensureOpen();
        this.ensureTransactional();
        this.getJmsSessionStub().sendMessages(this._messagesToSend);
        this._publishCount += (long)this._messagesToSend.size();
        this._messagesToSend.clear();
        this.getJmsSessionStub().commit();
    }

    public synchronized void rollback() throws JMSException {
        this.ensureOpen();
        this.ensureTransactional();
        this._messagesToSend.clear();
        this.getJmsSessionStub().rollback();
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            this._closing = true;
            this.getJmsSessionStub().beforeClose();
            this.stop();
            this.notifyConsumers();
            Enumeration producers = this.getProducers();
            while (producers.hasMoreElements()) {
                JmsMessageProducer producer = (JmsMessageProducer)producers.nextElement();
                producer.close();
            }
            Enumeration consumers = this.getConsumers();
            while (consumers.hasMoreElements()) {
                JmsMessageConsumer consumer = (JmsMessageConsumer)consumers.nextElement();
                consumer.close();
            }
            this._connection.removeSession(this);
            this._connection = null;
            this._messagesToSend.clear();
            this.getJmsSessionStub().close();
            this._stub = null;
            this._closed = true;
            this._closing = false;
        }
    }

    public synchronized void recover() throws JMSException {
        this.ensureOpen();
        if (this._transacted) {
            throw new IllegalStateException("Cannot recover from a transacted session");
        }
        this.getJmsSessionStub().recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.ensureOpen();
        return this._listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.ensureOpen();
        this._listener = listener;
    }

    public void run() {
        try {
            try {
                while (!this._messageCache.isEmpty()) {
                    Message message = (Message)this._messageCache.remove(0);
                    this._listener.onMessage(message);
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Error in the Session.run()", (Throwable)exception);
                Object var3_4 = null;
                this._messageCache.clear();
            }
            Object var3_3 = null;
            this._messageCache.clear();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this._messageCache.clear();
            throw throwable;
        }
    }

    public void setMessageListener(JmsMessageConsumer listener) throws JMSException {
        this.ensureOpen();
        this.enableAsynchronousDelivery(listener.getClientId(), listener.getLastMessageDelivered(), true);
    }

    public void removeMessageListener(JmsMessageConsumer listener) throws JMSException {
        this.ensureOpen();
        this.enableAsynchronousDelivery(listener.getClientId(), listener.getLastMessageDelivered(), false);
    }

    public void start() throws JMSException {
        this.ensureOpen();
        if (this._stopped) {
            this.getJmsSessionStub().startMessageDelivery();
            this._stopped = false;
            this.notifyConsumers();
        }
    }

    public void stop() throws JMSException {
        this.ensureOpen();
        if (!this._stopped) {
            this.getJmsSessionStub().stopMessageDelivery();
            this._stopped = true;
            this.notifyConsumers();
        }
    }

    public void acknowledgeMessage(Message message) throws JMSException {
        this.ensureOpen();
        if (this._ackMode == 2) {
            MessageImpl impl = (MessageImpl)message;
            this.getJmsSessionStub().acknowledgeMessage(impl.getClientId(), impl.getAckMessageID());
        }
    }

    public void enableAsynchronousDelivery(long clientId, String id, boolean enable) throws JMSException {
        this.ensureOpen();
        this.getJmsSessionStub().enableAsynchronousDelivery(clientId, id, enable);
    }

    public void onMessage(Message message) {
        if (message != null) {
            MessageImpl impl = (MessageImpl)message;
            impl.setJMSXRcvTimestamp(System.currentTimeMillis());
            this.execute(message);
        }
    }

    public void onMessages(Vector messages) {
        while (messages.size() > 0) {
            this.onMessage((Message)messages.remove(0));
        }
    }

    public void onMessageAvailable(long clientId) {
        this.notifyConsumers();
    }

    public synchronized void execute(Object object) {
        if (this._closed) {
            _log.error((Object)"Received a message for a closed session");
            return;
        }
        MessageImpl message = (MessageImpl)object;
        long clientId = message.getClientId();
        JmsMessageConsumer consumer = (JmsMessageConsumer)this._consumers.get(new Long(clientId));
        message.setSession(this);
        if (consumer != null) {
            if (this._listener != null) {
                this._listener.onMessage((Message)message);
            } else {
                consumer.onMessage(message);
            }
        } else {
            _log.error((Object)"Received a message for an inactive consumer");
        }
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public int getAckMode() {
        return this._ackMode;
    }

    public Message retrieveMessage(long clientId, long wait) throws JMSException {
        this.ensureOpen();
        boolean breakOnNextRead = false;
        long start = System.currentTimeMillis();
        long end = start + wait;
        MessageImpl message = null;
        while (true) {
            Object object = this._receiveLock;
            synchronized (object) {
                block15: {
                    if (this._closing || this._closed) {
                        break;
                    }
                    if (!this._stopped) {
                        message = (MessageImpl)this.getJmsSessionStub().receiveMessage(clientId, wait);
                    }
                    if (message != null) {
                        message.setSession(this);
                        break;
                    }
                    if (breakOnNextRead) {
                        break;
                    }
                    if (wait < 0L) {
                        break;
                    }
                    try {
                        if (wait > 0L) {
                            this._receiveLock.wait(wait);
                            long current = System.currentTimeMillis();
                            if (current >= end) {
                                breakOnNextRead = true;
                            } else {
                                wait = end - current;
                                if (wait == 0L) {
                                    breakOnNextRead = true;
                                }
                            }
                            break block15;
                        }
                        this._receiveLock.wait();
                    }
                    catch (InterruptedException ignore) {}
                }
            }
        }
        return message;
    }

    public synchronized Vector retrieveMessages(long clientId, int count) throws JMSException {
        this.ensureOpen();
        return this.getJmsSessionStub().receiveMessages(clientId, count);
    }

    public void destroy() throws JMSException {
        if (!this._closed) {
            this._closing = true;
            this.notifyConsumers();
            Enumeration producers = this.getProducers();
            while (producers.hasMoreElements()) {
                JmsMessageProducer producer = (JmsMessageProducer)producers.nextElement();
                producer.destroy();
            }
            Enumeration consumers = this.getConsumers();
            while (consumers.hasMoreElements()) {
                JmsMessageConsumer consumer = (JmsMessageConsumer)consumers.nextElement();
                consumer.destroy();
            }
            this._connection.removeSession(this);
            this._connection = null;
            this._messagesToSend.clear();
            this._stub = null;
            this._closed = true;
            this._closing = false;
        }
    }

    protected synchronized void sendMessage(Message message) throws JMSException {
        if (this._transacted) {
            if (message instanceof MessageImpl) {
                try {
                    message = (Message)((MessageImpl)message).clone();
                }
                catch (CloneNotSupportedException error) {
                    throw new JMSException(error.getMessage());
                }
            } else {
                message = this.convert(message);
            }
            this._messagesToSend.addElement(message);
        } else {
            if (!(message instanceof MessageImpl)) {
                message = this.convert(message);
            }
            this.getJmsSessionStub().sendMessage(message);
            ++this._publishCount;
        }
    }

    protected JmsSessionStubIfc getJmsSessionStub() {
        return this._stub;
    }

    protected JmsConnection getConnection() {
        return this._connection;
    }

    protected boolean checkForValidTemporaryDestination(JmsDestination destination) {
        boolean result = false;
        if (destination.isTemporaryDestination()) {
            JmsTemporaryDestination temp = (JmsTemporaryDestination)((Object)destination);
            if (temp.validForConnection(this.getConnection())) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    protected Enumeration getProducers() {
        return this._producers.elements();
    }

    protected Enumeration getConsumers() {
        return this._consumers.elements();
    }

    protected long getNextConsumerId() {
        return ++this._consumerIdSeed;
    }

    protected void addConsumer(JmsMessageConsumer consumer) {
        this._consumers.put(new Long(consumer.getClientId()), consumer);
    }

    protected void removeConsumer(JmsMessageConsumer consumer) {
        this._consumers.remove(new Long(consumer.getClientId()));
    }

    protected void addProducer(JmsMessageProducer producer) {
        this._producers.addElement(producer);
    }

    protected void removeProducer(JmsMessageProducer producer) {
        this._producers.remove(producer);
    }

    protected final boolean isClosed() {
        return this._closed;
    }

    protected void addMessage(Message message) {
        this._messageCache.addElement(message);
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("Cannot perform operation - session has been closed");
        }
    }

    private void ensureTransactional() throws IllegalStateException {
        if (!this._transacted) {
            throw new IllegalStateException("Cannot perform operatiorn - session is not transactional");
        }
    }

    private void notifyConsumers() {
        Object object = this._receiveLock;
        synchronized (object) {
            this._receiveLock.notifyAll();
        }
    }

    private Message convert(Message message) throws JMSException {
        MessageConverter converter = MessageConverterFactory.create(message);
        return converter.convert(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

