/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsQueueBrowser;
import org.exolab.jms.client.JmsQueueConnection;
import org.exolab.jms.client.JmsQueueReceiver;
import org.exolab.jms.client.JmsQueueSender;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTemporaryQueue;

class JmsQueueSession
extends JmsSession
implements QueueSession {
    public JmsQueueSession(JmsQueueConnection connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public synchronized Queue createQueue(String queueName) throws JMSException {
        this.ensureOpen();
        JmsQueue queue = null;
        if (queueName == null || queueName.length() <= 0) {
            throw new JMSException("Cannot create a queue with null or empty name");
        }
        queue = new JmsQueue(queueName);
        return queue;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        JmsQueueReceiver receiver = null;
        this.ensureOpen();
        if (queue == null) {
            throw new InvalidDestinationException("Cannot create receiver: argument 'queue' is null");
        }
        if (!this.checkForValidTemporaryDestination((JmsDestination)queue)) {
            throw new InvalidDestinationException("Cannot create a receiver for a temp queue that is not bound to this connection");
        }
        receiver = new JmsQueueReceiver(this, this.getNextConsumerId(), (JmsQueue)queue, selector);
        this.addReceiver(receiver);
        return receiver;
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        this.ensureOpen();
        JmsQueueSender sender = new JmsQueueSender(this, (JmsQueue)queue);
        this.addSender(sender);
        return sender;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        this.ensureOpen();
        if (queue == null) {
            throw new InvalidDestinationException("Cannot create browser: argument 'queue' is null");
        }
        JmsQueueBrowser browser = null;
        if (!this.checkForValidTemporaryDestination((JmsDestination)queue)) {
            throw new InvalidDestinationException("Cannot create a queue browser for a temp queue that is not bound to this connection");
        }
        browser = new JmsQueueBrowser(this, this.getNextConsumerId(), (JmsQueue)queue, selector);
        this.addBrowser(browser);
        return browser;
    }

    public synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.ensureOpen();
        JmsTemporaryQueue queue = new JmsTemporaryQueue();
        queue.setOwningConnection(this.getConnection());
        return queue;
    }

    protected void addReceiver(JmsQueueReceiver receiver) throws JMSException {
        this.getJmsSessionStub().createReceiver((JmsQueue)receiver.getQueue(), receiver.getClientId(), receiver.getMessageSelector());
        this.addConsumer(receiver);
    }

    protected void addSender(JmsQueueSender sender) {
        this.addProducer(sender);
    }

    protected void addBrowser(JmsQueueBrowser browser) throws JMSException {
        this.getJmsSessionStub().createBrowser((JmsQueue)browser.getQueue(), browser.getClientId(), browser.getMessageSelector());
        this.addConsumer(browser);
    }

    protected synchronized void removeReceiver(JmsQueueReceiver receiver) throws JMSException {
        if (!this.isClosed()) {
            this.removeMessageListener(receiver);
            this.getJmsSessionStub().deleteReceiver(receiver.getClientId());
        }
        this.removeConsumer(receiver);
    }

    protected synchronized void removeSender(JmsQueueSender sender) {
        this.removeProducer(sender);
    }

    protected synchronized void removeBrowser(JmsQueueBrowser browser) throws JMSException {
        if (!this.isClosed()) {
            this.getJmsSessionStub().deleteBrowser(browser.getClientId());
        }
        this.removeConsumer(browser);
    }
}

