/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.exolab.jms.client.JmsConnection;
import org.exolab.jms.client.JmsServerStubIfc;

public abstract class JmsConnectionFactory
implements ConnectionFactory,
ExceptionListener,
Externalizable,
Referenceable {
    static final long serialVersionUID = 1L;
    protected String _className = null;
    protected Hashtable _env = null;
    private transient Vector _connections = new Vector();
    private transient JmsServerStubIfc _proxy = null;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnectionFactoryBuilder;

    public JmsConnectionFactory() {
    }

    protected JmsConnectionFactory(String name, Hashtable env) {
        this._className = name;
        this._env = env;
    }

    public JmsServerStubIfc getProxy() throws JMSException {
        if (this._proxy == null) {
            try {
                Class[] argTypes = new Class[]{class$java$util$Hashtable == null ? (class$java$util$Hashtable = JmsConnectionFactory.class$("java.util.Hashtable")) : class$java$util$Hashtable};
                Object[] args = new Object[]{this._env};
                Class<?> factoryClass = Class.forName(this._className);
                Constructor<?> constructor = factoryClass.getDeclaredConstructor(argTypes);
                this._proxy = (JmsServerStubIfc)constructor.newInstance(args);
                this._proxy.setExceptionListener(this);
            }
            catch (InvocationTargetException exception) {
                if (exception.getTargetException() != null) {
                    throw new JMSException("Failed to create proxy: " + exception.getTargetException());
                }
                throw new JMSException("Failed to create proxy: " + exception);
            }
            catch (Exception exception) {
                throw new JMSException("Failed to create proxy: " + exception);
            }
        }
        return this._proxy;
    }

    protected void addConnection(JmsConnection connection) {
        this._connections.addElement(connection);
    }

    protected void removeConnection(JmsConnection connection) {
        this._connections.removeElement(connection);
    }

    protected boolean isManaged(JmsConnection connection) {
        return this._connections.contains(connection);
    }

    protected Enumeration getConnections() {
        return this._connections.elements();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeObject(this._className);
        stream.writeObject(this._env);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsConnectionFactory with version " + version + " is not supported.");
        }
        this._className = (String)stream.readObject();
        this._env = (Hashtable)stream.readObject();
    }

    public void onException(JMSException exception) {
        Enumeration iter = this._connections.elements();
        while (iter.hasMoreElements()) {
            JmsConnection connection = (JmsConnection)iter.nextElement();
            connection.notifyExceptionListener(exception);
        }
        this._connections.clear();
        this._proxy = null;
    }

    public Reference getReference() {
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr("serverClass", this._className), (class$org$exolab$jms$client$JmsConnectionFactoryBuilder == null ? (class$org$exolab$jms$client$JmsConnectionFactoryBuilder = JmsConnectionFactory.class$("org.exolab.jms.client.JmsConnectionFactoryBuilder")) : class$org$exolab$jms$client$JmsConnectionFactoryBuilder).getName(), null);
        Enumeration iter = this._env.keys();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            reference.add(new StringRefAddr(key, (String)this._env.get(key)));
        }
        return reference;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

