/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.authentication;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.ServiceException;
import org.exolab.jms.authentication.User;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.SecurityConfiguration;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.SQLHelper;

public class UserManager {
    private HashMap _userCache = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$authentication$UserManager == null ? (class$org$exolab$jms$authentication$UserManager = UserManager.class$("org.exolab.jms.authentication.UserManager")) : class$org$exolab$jms$authentication$UserManager));
    static /* synthetic */ Class class$org$exolab$jms$authentication$UserManager;

    protected UserManager() throws ServiceException {
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean createUser(User user) {
        boolean success = false;
        PersistenceAdapter adapter = DatabaseService.getAdapter();
        if (this._userCache.get(user.getUsername()) != null) return success;
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                adapter.addUser(connection, user);
                this.addToUserCache(user);
                connection.commit();
                success = true;
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to create user", (Throwable)exception);
                SQLHelper.rollback(connection);
                Object var7_6 = null;
                SQLHelper.close(connection);
                return success;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean updateUser(User user) {
        boolean success = false;
        PersistenceAdapter adapter = DatabaseService.getAdapter();
        if (this._userCache.get(user.getUsername()) == null) return success;
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                adapter.updateUser(connection, user);
                connection.commit();
                this.addToUserCache(user);
                success = true;
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to update user", (Throwable)exception);
                SQLHelper.rollback(connection);
                Object var7_6 = null;
                SQLHelper.close(connection);
                return success;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean deleteUser(User user) {
        boolean success = false;
        PersistenceAdapter adapter = DatabaseService.getAdapter();
        if (this._userCache.get(user.getUsername()) == null) return success;
        Connection connection = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                adapter.removeUser(connection, user);
                this.removeFromUserCache(user);
                success = true;
                connection.commit();
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to remove user", (Throwable)exception);
                SQLHelper.rollback(connection);
                Object var7_6 = null;
                SQLHelper.close(connection);
                return success;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return success;
    }

    public synchronized User getUser(User user) {
        return (User)this._userCache.get(user.getUsername());
    }

    public Iterator userNames() {
        return this._userCache.keySet().iterator();
    }

    public synchronized void destroy() {
        this._userCache.clear();
        this._userCache = null;
    }

    public synchronized boolean validateUser(String username, String password) {
        User user;
        boolean result = false;
        SecurityConfiguration config = ConfigurationManager.getConfig().getSecurityConfiguration();
        if (!config.getSecurityEnabled()) {
            result = true;
        }
        if ((user = (User)this._userCache.get(username)) != null && user.getPassword().equals(password)) {
            result = true;
        }
        return result;
    }

    protected void init() throws ServiceException {
        Connection connection = null;
        Object tm = null;
        try {
            try {
                connection = DatabaseService.getConnection();
                Enumeration iter = DatabaseService.getAdapter().getAllUsers(connection);
                connection.commit();
                while (iter.hasMoreElements()) {
                    User user = (User)iter.nextElement();
                    this.addToUserCache(user);
                }
            }
            catch (Exception exception) {
                SQLHelper.rollback(connection);
                _log.error((Object)"Failed to initialise UserManager", (Throwable)exception);
                throw new ServiceException((Throwable)exception);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        this.registerConfiguredUsers();
    }

    protected void addToUserCache(User user) {
        if (!this._userCache.containsKey(user.getUsername())) {
            this._userCache.put(user.getUsername(), user);
        }
    }

    protected void removeFromUserCache(User user) {
        this._userCache.remove(user.getUsername());
    }

    protected void registerConfiguredUsers() {
        Configuration config = ConfigurationManager.getConfig();
        if (config.getUsers() != null) {
            org.exolab.jms.config.User[] users = config.getUsers().getUser();
            int i = 0;
            while (i < users.length) {
                User user = new User(users[i].getName(), users[i].getPassword());
                this.createUser(user);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

