/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.util;

import java.util.Comparator;
import java.util.Vector;

public class OrderedQueue {
    private Vector queue_ = null;
    private Comparator comparator_ = null;

    public OrderedQueue(Comparator comparator) {
        this.comparator_ = comparator;
        this.queue_ = new Vector();
    }

    public synchronized void add(Object object) {
        if (this.queue_.size() == 0) {
            this.queue_.addElement(object);
        } else {
            int start = 0;
            int end = this.queue_.size() - 1;
            if (this.comparator_.compare(object, this.queue_.firstElement()) < 0) {
                this.queue_.insertElementAt(object, 0);
            } else if (this.comparator_.compare(object, this.queue_.lastElement()) > 0) {
                this.queue_.addElement(object);
            } else {
                while (true) {
                    int result;
                    int midpoint = start + (end - start) / 2;
                    if ((end - start) % 2 != 0) {
                        ++midpoint;
                    }
                    if ((result = this.comparator_.compare(object, this.queue_.elementAt(midpoint))) == 0) {
                        this.queue_.insertElementAt(object, midpoint);
                        break;
                    }
                    if (start + 1 == end) {
                        this.queue_.insertElementAt(object, end);
                        break;
                    }
                    if (result > 0) {
                        start = midpoint;
                        continue;
                    }
                    end = midpoint;
                }
            }
        }
    }

    public synchronized boolean remove(Object object) {
        return this.queue_.remove(object);
    }

    public synchronized void clear() {
        this.queue_.clear();
    }

    public int size() {
        return this.queue_.size();
    }

    public Object firstElement() {
        return this.queue_.firstElement();
    }

    public synchronized Object removeFirstElement() {
        return this.queue_.remove(0);
    }
}

