/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.util;

public class FifoQueue {
    private Object[] queue_;
    private int capacity_;
    private int size_;
    private int head_;
    private int tail_;

    public FifoQueue(int capacity) {
        this.capacity_ = capacity > 0 ? capacity : 1;
        this.queue_ = new Object[this.capacity_];
        this.head_ = 0;
        this.tail_ = 0;
        this.size_ = 0;
    }

    public int getCapacity() {
        return this.capacity_;
    }

    public synchronized int getSize() {
        return this.size_;
    }

    public synchronized boolean isEmpty() {
        return this.size_ == 0;
    }

    public synchronized boolean isFull() {
        return this.size_ == this.capacity_;
    }

    public synchronized void add(Object obj) throws InterruptedException {
        this.waitWhileFull();
        this.queue_[this.head_] = obj;
        this.head_ = (this.head_ + 1) % this.capacity_;
        ++this.size_;
        this.notifyAll();
    }

    public synchronized void add(Object[] list) throws InterruptedException {
        int i = 0;
        while (i < list.length) {
            this.add(list[i]);
            ++i;
        }
    }

    public synchronized Object get() throws InterruptedException {
        this.waitWhileEmpty();
        Object obj = this.queue_[this.tail_];
        this.queue_[this.tail_] = null;
        this.tail_ = (this.tail_ + 1) % this.capacity_;
        --this.size_;
        this.notifyAll();
        return obj;
    }

    public synchronized Object[] getAll() throws InterruptedException {
        Object[] list = new Object[this.size_];
        int i = 0;
        while (i < list.length) {
            list[i] = this.get();
            ++i;
        }
        return list;
    }

    public synchronized boolean waitUntilEmpty(long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEmpty();
            return true;
        }
        long endTime = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (!this.isEmpty() && remaining > 0L) {
            this.wait(remaining);
            remaining = endTime - System.currentTimeMillis();
        }
        return this.isEmpty();
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilFull() throws InterruptedException {
        while (!this.isFull()) {
            this.wait();
        }
    }

    public synchronized void waitWhileFull() throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
    }
}

