/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.util;

import org.exolab.core.util.Messages;

public class FastThreadLocal
implements Runnable {
    private Entry[] _table;
    private int _staleTimeout = 600000;
    private static final int TABLE_SIZE = 1103;

    public FastThreadLocal() {
        this(1103);
    }

    public FastThreadLocal(int size) {
        this._table = new Entry[size];
        Thread thread = new Thread((Runnable)this, Messages.message("castor.misc.threadLocalDaemonName"));
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        int hash = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[hash];
        while (entry != null && entry.thread != thread) {
            entry = entry.next;
        }
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public void set(Object value) {
        Thread thread = Thread.currentThread();
        int hash = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[hash];
        while (entry != null && entry.thread != thread) {
            entry = entry.next;
        }
        if (entry != null) {
            entry.value = value;
            return;
        }
        entry = new Entry();
        entry.value = value;
        entry.thread = thread;
        Entry[] entryArray = this._table;
        synchronized (entryArray) {
            entry.next = this._table[hash];
            this._table[hash] = entry;
        }
    }

    public Object get(Thread thread) {
        int hash = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[hash];
        while (entry != null && entry.thread != thread) {
            entry = entry.next;
        }
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void remove(Thread thread) {
        Thread thread2 = thread;
        synchronized (thread2) {
            Entry entry;
            int hash = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
            Entry[] entryArray = this._table;
            synchronized (entryArray) {
                entry = this._table[hash];
                if (entry == null) {
                    return;
                }
                if (entry.thread == thread) {
                    this._table[hash] = entry.next;
                    return;
                }
            }
            while (entry.next != null && entry.next.thread != thread) {
                entry = entry.next;
            }
            if (entry.next == null) return;
            entry.next = entry.next.next;
            return;
        }
    }

    public Thread[] listThreads(Object value) {
        Thread[] threads = null;
        int i = 0;
        while (i < this._table.length) {
            Entry entry = this._table[i];
            while (entry != null) {
                if (value == null || entry.value == value) {
                    if (threads == null) {
                        threads = new Thread[]{entry.thread};
                    } else {
                        Thread[] newThreads = new Thread[threads.length + 1];
                        System.arraycopy(newThreads, 0, threads, 0, threads.length);
                        newThreads[threads.length] = entry.thread;
                        threads = newThreads;
                    }
                }
                entry = entry.next;
            }
            ++i;
        }
        return threads;
    }

    public void run() {
        block5: while (true) {
            try {
                Thread.sleep(this._staleTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int i = 0;
            while (true) {
                Entry entry;
                if (i >= this._table.length) continue block5;
                Entry[] entryArray = this._table;
                synchronized (entryArray) {
                    entry = this._table[i];
                    while (entry != null && !entry.thread.isAlive()) {
                        this._table[i] = entry.next;
                        entry = entry.next;
                    }
                }
                if (entry != null) {
                    while (entry.next != null) {
                        if (!entry.next.thread.isAlive()) {
                            entry.next = entry.next.next;
                            continue;
                        }
                        entry = entry.next;
                    }
                }
                ++i;
            }
            break;
        }
    }

    class Entry {
        Object value;
        Entry next;
        Thread thread;

        Entry() {
        }
    }
}

