/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.threadPool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.util.FifoQueue;

class ThreadPoolWorker {
    private ThreadGroup _group;
    private FifoQueue _idleWorkers;
    private FifoQueue _waitUntilWork;
    private Thread _worker;
    private volatile boolean _noStopRequested;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$threadPool$ThreadPoolWorker == null ? (class$org$exolab$core$threadPool$ThreadPoolWorker = ThreadPoolWorker.class$("org.exolab.core.threadPool.ThreadPoolWorker")) : class$org$exolab$core$threadPool$ThreadPoolWorker));
    static /* synthetic */ Class class$org$exolab$core$threadPool$ThreadPoolWorker;

    public ThreadPoolWorker(ThreadGroup group, String name, FifoQueue idleWorkers) {
        this._group = group;
        this._idleWorkers = idleWorkers;
        this._waitUntilWork = new FifoQueue(1);
        this._noStopRequested = true;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    ThreadPoolWorker.this.runWork();
                }
                catch (Exception exception) {
                    _log.error((Object)("Thread " + ThreadPoolWorker.this._worker.getName() + ": terminating on exception"), (Throwable)exception);
                }
            }
        };
        this._worker = new Thread(this._group, r, name);
        this._worker.setDaemon(this._group.isDaemon());
        this._worker.start();
    }

    public void process(Runnable target) throws InterruptedException {
        this._waitUntilWork.add(target);
    }

    public void stopRequest() {
        this._noStopRequested = false;
        this._worker.interrupt();
    }

    public boolean isAlive() {
        return this._worker.isAlive();
    }

    private void runWork() {
        while (this._noStopRequested) {
            try {
                this._idleWorkers.add(this);
                Runnable r = (Runnable)this._waitUntilWork.get();
                this.runIt(r);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runIt(Runnable r) {
        try {
            try {
                r.run();
            }
            catch (Exception exception) {
                _log.error((Object)("Thread " + this._worker.getName() + ": uncaught exception fell through from run()"), (Throwable)exception);
                Object var4_3 = null;
                Thread.interrupted();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.interrupted();
            throw throwable;
        }
        Thread.interrupted();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

