/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.threadPool;

import org.exolab.core.threadPool.CompletionListener;
import org.exolab.core.threadPool.QueueWorker;
import org.exolab.core.threadPool.ThreadPoolWorker;
import org.exolab.core.util.FifoQueue;

public class ThreadPool {
    private final String _name;
    private ThreadGroup _group;
    private FifoQueue _idleWorkers;
    private ThreadPoolWorker[] _workers;
    private QueueWorker _queue;
    private static volatile int _poolSeed = 0;

    public ThreadPool(int threads) {
        this(threads, false);
    }

    public ThreadPool(int threads, boolean daemon) {
        this("ThreadPool-" + ++_poolSeed, threads, daemon);
    }

    public ThreadPool(String name, int threads) {
        this(name, threads, false);
    }

    public ThreadPool(String name, int threads, boolean daemon) {
        this(new ThreadGroup(name), threads, daemon);
    }

    public ThreadPool(ThreadGroup group, int threads, boolean daemon) {
        this._name = group.getName();
        this._group = new ThreadGroup(this._name);
        if (daemon) {
            this._group.setDaemon(true);
        }
        if (threads < 1) {
            throw new IllegalArgumentException("Argument 'threads' must be > 0");
        }
        this._idleWorkers = new FifoQueue(threads);
        this._workers = new ThreadPoolWorker[threads];
        int i = 0;
        while (i < this._workers.length) {
            String id = this._name + "-Worker-" + i;
            this._workers[i] = new ThreadPoolWorker(this._group, id, this._idleWorkers);
            ++i;
        }
    }

    public void execute(Runnable target) throws InterruptedException {
        ThreadPoolWorker worker = (ThreadPoolWorker)this._idleWorkers.get();
        worker.process(target);
    }

    public void queue(Runnable target) {
        this.queue(target, null);
    }

    public synchronized void queue(Runnable target, CompletionListener listener) {
        if (this._queue == null) {
            this._queue = new QueueWorker(this, this._group, this._name + "-QueueWorker");
        }
        this._queue.add(target, listener);
    }

    public void stopRequestIdleWorkers() {
        try {
            Object[] idle = this._idleWorkers.getAll();
            int i = 0;
            while (i < idle.length) {
                ((ThreadPoolWorker)idle[i]).stopRequest();
                ++i;
            }
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopRequestAllWorkers() {
        this.stopRequestIdleWorkers();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        int i = 0;
        while (i < this._workers.length) {
            if (this._workers[i].isAlive()) {
                this._workers[i].stopRequest();
            }
            ++i;
        }
        if (this._queue != null && this._queue.isAlive()) {
            this._queue.stop();
        }
    }

    boolean hasIdleThread() {
        return !this._idleWorkers.isEmpty();
    }
}

