/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.threadPool;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.threadPool.CompletionListener;
import org.exolab.core.threadPool.ThreadPool;

class QueueWorker {
    private ThreadPool _pool;
    private LinkedList _queue = new LinkedList();
    private Thread _worker;
    private volatile boolean _stop = false;
    private static final Log _category = LogFactory.getLog((String)"org.exolab.core.threadPool");

    public QueueWorker(ThreadPool pool, ThreadGroup group, String name) {
        this._pool = pool;
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    QueueWorker.this.runWork();
                }
                catch (Exception exception) {
                    _category.error((Object)("Thread " + QueueWorker.this._worker.getName() + ": terminating on exception"), (Throwable)exception);
                }
            }
        };
        this._worker = new Thread(group, worker, name);
        this._worker.setDaemon(true);
        this._worker.start();
    }

    public void add(Runnable target, CompletionListener listener) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.add(new Executor(target, listener));
            this._queue.notify();
        }
    }

    public void stop() {
        this._stop = true;
        this._worker.interrupt();
    }

    public boolean isAlive() {
        return this._worker.isAlive();
    }

    private void runWork() {
        while (!this._stop) {
            Executor target = null;
            LinkedList linkedList = this._queue;
            synchronized (linkedList) {
                if (this._queue.isEmpty()) {
                    try {
                        this._queue.wait();
                    }
                    catch (InterruptedException ignore) {}
                } else {
                    target = (Executor)this._queue.removeFirst();
                }
            }
            if (this._stop || target == null) continue;
            try {
                this._pool.execute(target);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class Executor
    implements Runnable {
        private Runnable _target;
        private CompletionListener _listener;

        public Executor(Runnable target, CompletionListener listener) {
            this._target = target;
            this._listener = listener;
        }

        public void run() {
            try {
                try {
                    this._target.run();
                }
                catch (Throwable exception) {
                    _category.error((Object)("Thread " + Thread.currentThread().getName() + "- uncaught exception fell through from run"), exception);
                    Object var3_2 = null;
                    if (this._listener != null) {
                        this._listener.completed(this._target);
                    }
                }
                Object var3_1 = null;
                if (this._listener != null) {
                    this._listener.completed(this._target);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this._listener != null) {
                    this._listener.completed(this._target);
                }
                throw throwable;
            }
        }
    }
}

