/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.service;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.ServiceAlreadyExistsException;
import org.exolab.core.service.ServiceDoesNotExistException;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceManagerException;
import org.exolab.core.service.Serviceable;

public class ServiceGroup {
    private HashMap _services = new HashMap();
    private ArrayList _serviceOrder = new ArrayList();
    private static final Log log = LogFactory.getLog((Class)(class$org$exolab$core$service$ServiceGroup == null ? (class$org$exolab$core$service$ServiceGroup = ServiceGroup.class$("org.exolab.core.service.ServiceGroup")) : class$org$exolab$core$service$ServiceGroup));
    static /* synthetic */ Class class$org$exolab$core$service$ServiceGroup;

    public synchronized void add(String name, Serviceable service) throws ServiceAlreadyExistsException, ServiceManagerException {
        if (this._services.containsKey(name)) {
            throw new ServiceAlreadyExistsException("Service with name=" + name + " has already been registered");
        }
        if (!service.getState().isStopped()) {
            throw new ServiceManagerException("Service with name=" + name + " is in state=" + service.getState());
        }
        this._services.put(name, service);
        this._serviceOrder.add(name);
    }

    public synchronized void remove(String name) throws ServiceDoesNotExistException, ServiceManagerException {
        if (!this._services.containsKey(name)) {
            throw new ServiceDoesNotExistException("Service with name " + name + " is not registered");
        }
        Serviceable service = (Serviceable)this._services.get(name);
        if (!service.getState().isStopped()) {
            throw new ServiceManagerException("Cannot remove service=" + name + " while it is in state=" + service.getState());
        }
        this._services.remove(name);
        ((AbstractCollection)this._serviceOrder).remove(name);
    }

    public synchronized void remove(Serviceable service) throws ServiceDoesNotExistException, ServiceManagerException {
        this.remove(service.getName());
    }

    public synchronized Iterator getServiceNames() {
        return ((AbstractList)new ArrayList(this._serviceOrder)).iterator();
    }

    public synchronized Serviceable getServiceByName(String name) {
        return (Serviceable)this._services.get(name);
    }

    public synchronized void startAll() throws ServiceManagerException {
        Iterator iter = ((AbstractList)this._serviceOrder).iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Serviceable service = this.getServiceByName(name);
            try {
                if (service.getState().isRunning()) continue;
                service.start();
                log.info((Object)("Started service [" + service.getName() + "]"));
            }
            catch (ServiceException exception) {
                log.error((Object)exception);
                throw new ServiceManagerException(exception.getMessage());
            }
        }
    }

    public synchronized void stopAll() {
        Iterator iter = ((AbstractList)this._serviceOrder).iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Serviceable service = this.getServiceByName(name);
            if (service.getState().isStopped()) continue;
            try {
                service.stop();
                log.info((Object)("Stopped service [" + service.getName() + "]"));
            }
            catch (ServiceException exception) {
                log.error((Object)exception);
            }
        }
    }

    public synchronized void removeAll() {
        this.stopAll();
        this._services.clear();
        this._serviceOrder.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

