/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.service;

import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.core.service.Serviceable;

public abstract class Service
implements Serviceable {
    private String _name = null;
    private volatile ServiceState _state = ServiceState.STOPPED;

    protected Service() {
    }

    protected Service(String name) {
        this._name = name;
    }

    public synchronized void start() throws ServiceException {
        if (!this._state.isStopped()) {
            throw new ServiceException("Failed to start service " + this);
        }
        this._state = ServiceState.RUNNING;
    }

    public synchronized void stop() throws ServiceException {
        if (!this._state.isRunning()) {
            throw new ServiceException("Failed to stop service " + this);
        }
        this._state = ServiceState.STOPPED;
    }

    public synchronized void restart() throws ServiceException {
        if (this._state.isRunning()) {
            this.stop();
        }
        this.start();
    }

    public ServiceState getState() {
        return this._state;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Service:[");
        buf.append("name=");
        buf.append(this._name);
        buf.append("state=");
        buf.append(this._state);
        buf.append("]");
        return buf.toString();
    }

    protected void setState(ServiceState state) {
        this._state = state;
    }
}

