/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.mipc;

import java.io.IOException;
import java.io.Serializable;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.core.mipc.MessageInput;
import org.exolab.core.mipc.MessageOutput;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.Packet;
import org.exolab.core.mipc.Queue;
import org.exolab.core.mipc.QueueInputStream;
import org.exolab.core.mipc.QueueOutputStream;

public class ObjectChannel
implements IpcIfc {
    private MultiplexConnectionIfc _connection = null;
    private MessageInput _input = null;
    private MessageOutput _output = null;
    private String _label = null;

    public ObjectChannel(String label, MultiplexConnectionIfc connection) {
        this._connection = connection;
        this._label = label;
        Queue queue = new Queue();
        QueueOutputStream queueOut = new QueueOutputStream(queue);
        this._output = this._connection.register(this._label, queueOut);
        this._input = new QueueInputStream(queue);
    }

    public void close() throws IOException {
        this._connection.deregister(this._label);
        this._input.close();
    }

    public void send(Serializable object) throws IOException {
        this._output.send(new Packet(this._label, object));
    }

    public Object receive() throws ClassNotFoundException, IOException {
        Packet packet = this._input.receive();
        return packet.getObject();
    }

    public String toString() {
        return "ObjectChannel - " + this._label;
    }

    public MultiplexConnectionIfc getConnection() {
        return this._connection;
    }
}

