/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.mipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.mipc.ConnectionNotifierIfc;
import org.exolab.core.mipc.MultiplexConnection;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.MultiplexConnectionServerIfc;

public class MultiplexConnectionServer
extends Thread
implements MultiplexConnectionServerIfc {
    private ServerSocket _server;
    private ThreadGroup _connections = new ThreadGroup("MultiplexConnections");
    private boolean _active = true;
    private ConnectionNotifierIfc _notifier = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$mipc$MultiplexConnectionServer == null ? (class$org$exolab$core$mipc$MultiplexConnectionServer = MultiplexConnectionServer.class$("org.exolab.core.mipc.MultiplexConnectionServer")) : class$org$exolab$core$mipc$MultiplexConnectionServer));
    static /* synthetic */ Class class$org$exolab$core$mipc$MultiplexConnectionServer;

    public MultiplexConnectionServer(int port, ConnectionNotifierIfc notifier) throws IOException {
        this(null, port, notifier);
    }

    public MultiplexConnectionServer(InetAddress address, int port, ConnectionNotifierIfc notifier) throws IOException {
        this._notifier = notifier;
        this._server = new ServerSocket(port, -1, address);
    }

    public void run() {
        _log.debug((Object)("MultiplexConnectionServer is ready, on port " + this._server.getLocalPort()));
        while (this._active) {
            try {
                Socket s = this._server.accept();
                _log.debug((Object)"MultiplexConnectionServer accept()'ed connection");
                ThreadGroup threadGroup = this._connections;
                synchronized (threadGroup) {
                    if (this._active) {
                        MultiplexConnection mc = new MultiplexConnection(this._connections, s);
                        this._notifier.connected(mc);
                        mc.start();
                    } else {
                        s.close();
                    }
                }
            }
            catch (IOException exception) {
                _log.error((Object)"Failed to create new connection", (Throwable)exception);
            }
        }
    }

    public void shutdownAll() throws IOException {
        _log.debug((Object)"MultiplexConnectionServer shutdownAll called.");
        ThreadGroup threadGroup = this._connections;
        synchronized (threadGroup) {
            int size = this._connections.activeCount();
            Thread[] connections = new Thread[size];
            this._connections.enumerate(connections, false);
            int i = 0;
            int j = size;
            while (i < j) {
                ((MultiplexConnectionIfc)((Object)connections[i])).finish();
                ++i;
            }
            this._active = false;
            this._server.close();
            this.interrupt();
        }
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    public String getHost() {
        String host = "127.0.0.1";
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException exception) {
            _log.error((Object)"Failed to get IP address for this host", (Throwable)exception);
        }
        return host;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

