/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.mipc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.mipc.Demultiplexer;
import org.exolab.core.mipc.DisconnectionEventListener;
import org.exolab.core.mipc.MessageCopier;
import org.exolab.core.mipc.MessageInputStream;
import org.exolab.core.mipc.MessageOutput;
import org.exolab.core.mipc.MessageOutputStream;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.Queue;
import org.exolab.core.mipc.QueueInputStream;
import org.exolab.core.mipc.QueueOutputStream;

public class MultiplexConnection
extends Thread
implements MultiplexConnectionIfc {
    private InputStream _in;
    private OutputStream _out;
    private Queue _queue;
    private QueueOutputStream _queueOut;
    private Demultiplexer _demux;
    private MessageCopier _copier;
    private DisconnectionEventListener _listener = null;
    protected boolean _finished = false;
    private String _host = null;
    private int _port = 0;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$core$mipc$MultiplexConnection == null ? (class$org$exolab$core$mipc$MultiplexConnection = MultiplexConnection.class$("org.exolab.core.mipc.MultiplexConnection")) : class$org$exolab$core$mipc$MultiplexConnection));
    static /* synthetic */ Class class$org$exolab$core$mipc$MultiplexConnection;

    public MultiplexConnection(String hostname, int port) throws UnknownHostException, IOException {
        this(new Socket(hostname, port));
    }

    public MultiplexConnection(Socket socket) throws IOException {
        super(MultiplexConnection.getName(socket));
        this.init(socket);
    }

    public MultiplexConnection(ThreadGroup group, Socket socket) throws IOException {
        super(group, MultiplexConnection.getName(socket));
        this.init(socket);
    }

    public void finish() {
        this._finished = true;
        if (this._copier != null) {
            this._copier.finish();
        }
        if (this._demux != null) {
            this._demux.finish();
        }
    }

    public void setDisconnectionEventListener(DisconnectionEventListener listener) {
        this._listener = listener;
    }

    public void run() {
        QueueInputStream queueIn = new QueueInputStream(this._queue);
        MessageOutputStream messageOut = new MessageOutputStream(this._out);
        this._copier = new MessageCopier(this, queueIn, messageOut);
        try {
            try {
                this._copier.start();
                this._demux.run();
            }
            catch (Exception exception) {
                if (!this._finished) {
                    _log.debug((Object)"MultiplexConnection terminating on exception", (Throwable)exception);
                }
                Object var5_4 = null;
                this._copier.finish();
            }
            Object var5_3 = null;
            this._copier.finish();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._copier.finish();
            throw throwable;
        }
    }

    public MessageOutput register(String label, MessageOutput out) {
        this._demux.register(label, out);
        return this._queueOut;
    }

    public void deregister(String label) {
        this._demux.deregister(label);
    }

    public void disconnected() {
        this.finish();
        if (this._listener != null) {
            this._listener.disconnected(this);
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    protected void init(Socket socket) throws IOException {
        this._in = socket.getInputStream();
        this._out = socket.getOutputStream();
        this._host = socket.getLocalAddress().getHostName();
        this._port = socket.getLocalPort();
        this._queue = new Queue();
        this._queueOut = new QueueOutputStream(this._queue);
        this._demux = new Demultiplexer(new MessageInputStream(this._in), this);
        this.setDaemon(true);
    }

    private static String getName(Socket socket) throws IOException {
        String host = socket.getLocalAddress().getHostName();
        int port = socket.getLocalPort();
        return "MultiplexConnection-" + host + ":" + port;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

