/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger.tcp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.exolab.core.messenger.AcceptorEventListener;
import org.exolab.core.messenger.AcceptorEventNotifier;
import org.exolab.core.messenger.ConnectionHandler;
import org.exolab.core.messenger.ManagedConnection;
import org.exolab.core.messenger.ManagedConnectionAcceptor;
import org.exolab.core.messenger.MessengerException;
import org.exolab.core.messenger.tcp.TcpConnector;
import org.exolab.core.messenger.tcp.URIHelper;
import org.exolab.core.util.URI;

class TcpManagedConnectionAcceptor
implements ManagedConnectionAcceptor {
    private TcpConnector _connector;
    private final String _uri;
    private ServerSocket _socket;
    private HashMap _handlers = new HashMap();
    private AcceptorEventNotifier _listeners = new AcceptorEventNotifier();

    public TcpManagedConnectionAcceptor(TcpConnector connector, String uri, ServerSocket socket) {
        if (connector == null) {
            throw new IllegalArgumentException("Argument 'connector' is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        if (socket == null) {
            throw new IllegalArgumentException("Argument 'socket' is null");
        }
        this._connector = connector;
        this._uri = uri;
        this._socket = socket;
    }

    public String getURI() {
        return this._uri;
    }

    public synchronized void accept(String uri, ConnectionHandler handler) throws MalformedURLException, RemoteException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null");
        }
        URI parser = URIHelper.getURI(uri);
        String address = URIHelper.getAddress(parser);
        if (!address.equals(this._uri)) {
            throw new MessengerException("Mismatched URI. Acceptor is accepting physical connections on URI=" + uri);
        }
        String name = parser.getPath();
        if (name == null || name.trim().length() == 0) {
            throw new MalformedURLException("No connection name specified in URI=" + uri);
        }
        if (this._handlers.containsKey(name)) {
            throw new MessengerException("A connection handler is already registered for URI=" + uri);
        }
        this._handlers.put(name, handler);
    }

    public synchronized void close(String uri) throws MalformedURLException, RemoteException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        URI parser = URIHelper.getURI(uri);
        String address = URIHelper.getAddress(parser);
        if (!address.equals(this._uri)) {
            throw new MessengerException("Mismatched URI. Acceptor is accepting physical connections on URI=" + uri);
        }
        String name = parser.getPath();
        ConnectionHandler handler = (ConnectionHandler)this._handlers.remove(name);
        if (this._handlers.isEmpty()) {
            this.close();
        }
    }

    public ManagedConnection accept() throws RemoteException {
        HashMap handlers;
        Socket socket;
        try {
            socket = this._socket.accept();
        }
        catch (IOException exception) {
            AcceptorEventNotifier listeners;
            TcpManagedConnectionAcceptor tcpManagedConnectionAcceptor = this;
            synchronized (tcpManagedConnectionAcceptor) {
                listeners = this._listeners;
                this.doClose();
            }
            if (listeners != null) {
                MessengerException wrapper = new MessengerException(exception.getMessage(), exception);
                listeners.error(this, wrapper);
            }
            throw new MessengerException("Failed to accept TCP connection", exception);
        }
        TcpManagedConnectionAcceptor tcpManagedConnectionAcceptor = this;
        synchronized (tcpManagedConnectionAcceptor) {
            handlers = (HashMap)this._handlers.clone();
        }
        return this._connector.accepted(socket, handlers);
    }

    public void close() throws RemoteException {
        AcceptorEventNotifier listeners;
        TcpManagedConnectionAcceptor tcpManagedConnectionAcceptor = this;
        synchronized (tcpManagedConnectionAcceptor) {
            listeners = this._listeners;
            this.doClose();
        }
        if (listeners != null) {
            listeners.closed(this);
        }
    }

    public void addAcceptorEventListener(AcceptorEventListener listener) {
        this._listeners.addAcceptorEventListener(listener);
    }

    public void removeAcceptorEventListener(AcceptorEventListener listener) {
        this._listeners.removeAcceptorEventListener(listener);
    }

    protected void doClose() throws RemoteException {
        if (this._socket != null) {
            try {
                try {
                    this._socket.close();
                }
                catch (IOException exception) {
                    throw new MessengerException(exception.getMessage(), exception);
                }
                Object var3_1 = null;
                this._connector = null;
                this._socket = null;
                this._listeners = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this._connector = null;
                this._socket = null;
                this._listeners = null;
                throw throwable;
            }
        }
    }
}

