/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.core.messenger.tcp;

import java.io.IOException;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exolab.core.messenger.ConnectionHandler;
import org.exolab.core.messenger.Context;
import org.exolab.core.messenger.ManagedPacketConnection;
import org.exolab.core.messenger.tcp.TcpMultiplexerFactory;

class TcpManagedConnection
extends ManagedPacketConnection {
    private Socket _socket;

    public TcpManagedConnection(Context context, Socket socket) throws RemoteException {
        this(context, socket, null);
    }

    public TcpManagedConnection(Context context, Socket socket, HashMap handlers) throws RemoteException {
        super(context, new TcpMultiplexerFactory(socket));
        this._socket = socket;
        if (handlers != null) {
            Iterator iter = handlers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                ConnectionHandler handler = (ConnectionHandler)entry.getValue();
                this.accept(name, handler);
            }
        }
        try {
            this.initialise();
        }
        catch (RemoteException exception) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw exception;
        }
    }

    protected synchronized void doClose() throws RemoteException {
        super.doClose();
        if (this._socket != null) {
            try {
                try {
                    this._socket.close();
                }
                catch (IOException ignore) {
                    Object var3_2 = null;
                    this._socket = null;
                }
                Object var3_1 = null;
                this._socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._socket = null;
                throw throwable;
            }
        }
    }
}

